/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.utilities.core;

import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTUtils;
import chrriis.dj.nativeswing.swtimpl.utilities.core.NativeFileTypeLauncher;
import chrriis.dj.nativeswing.swtimpl.utilities.internal.INativeFileTypeLauncher;
import chrriis.dj.nativeswing.swtimpl.utilities.internal.INativeFileTypeLauncherStatic;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

class NativeFileTypeLauncherStatic
implements INativeFileTypeLauncherStatic {
    private static Map<Integer, FileTypeLauncherInfo> idToFileTypeLauncherInfoMap;
    private static Map<Program, FileTypeLauncherInfo> programToFileTypeLauncherInfoMap;
    private static boolean isNativeInitialized;
    private static boolean hasInitializedLaunchers;
    private static boolean hasInitializedExtensions;
    private static Map<Integer, NativeFileTypeLauncher> idToFileTypeLauncherMap;
    private static boolean isDefaultIconLoaded;
    private static ImageIcon defaultIcon;

    NativeFileTypeLauncherStatic() {
    }

    private static boolean isProgramValid(Program program) {
        String name = program.getName();
        return name != null && name.length() > 0;
    }

    private static void initNative() {
        if (isNativeInitialized) {
            return;
        }
        isNativeInitialized = true;
        programToFileTypeLauncherInfoMap = new HashMap<Program, FileTypeLauncherInfo>();
        idToFileTypeLauncherInfoMap = new HashMap<Integer, FileTypeLauncherInfo>();
    }

    public void load() {
        this.initializeExtensions();
        NativeFileTypeLauncherStatic.initializeLaunchers();
    }

    private static void initializeLaunchers() {
        if (hasInitializedLaunchers) {
            return;
        }
        hasInitializedLaunchers = true;
        new CMN_initializeLaunchers().syncExec(true, new Object[0]);
    }

    void initializeExtensions() {
        if (hasInitializedExtensions) {
            return;
        }
        hasInitializedExtensions = true;
        new CMN_initializeExtensions().syncExec(true, new Object[0]);
    }

    public String[] getAllRegisteredExtensions() {
        this.initializeExtensions();
        return (String[])new CMN_getAllRegisteredExtensions().syncExec(true, new Object[0]);
    }

    public INativeFileTypeLauncher getLauncher(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String extension = fileName.substring(index);
        Integer id2 = (Integer)new CMN_getLauncherID().syncExec(true, extension);
        if (id2 == null) {
            return null;
        }
        NativeFileTypeLauncher fileTypeLauncher = idToFileTypeLauncherMap.get(id2);
        if (fileTypeLauncher == null) {
            fileTypeLauncher = new NativeFileTypeLauncher(this, id2);
            idToFileTypeLauncherMap.put(id2, fileTypeLauncher);
        }
        return fileTypeLauncher;
    }

    public INativeFileTypeLauncher[] getLaunchers() {
        this.load();
        int[] ids = (int[])new CMN_getLauncherIDs().syncExec(true, new Object[0]);
        if (idToFileTypeLauncherMap == null) {
            idToFileTypeLauncherMap = new HashMap<Integer, NativeFileTypeLauncher>();
        }
        INativeFileTypeLauncher[] fileTypeLaunchers = new NativeFileTypeLauncher[ids.length];
        int i2 = 0;
        while (i2 < ids.length) {
            int id2 = ids[i2];
            NativeFileTypeLauncher fileTypeLauncher = idToFileTypeLauncherMap.get(id2);
            if (fileTypeLauncher == null) {
                fileTypeLauncher = new NativeFileTypeLauncher(this, id2);
                idToFileTypeLauncherMap.put(id2, fileTypeLauncher);
            }
            fileTypeLaunchers[i2] = fileTypeLauncher;
            ++i2;
        }
        return fileTypeLaunchers;
    }

    public ImageIcon getDefaultIcon() {
        if (!isDefaultIconLoaded) {
            Icon defaultIcon_;
            isDefaultIconLoaded = true;
            try {
                File tmpFile = File.createTempFile("~djn", "~.qwertyuiop");
                tmpFile.deleteOnExit();
                defaultIcon_ = FileSystemView.getFileSystemView().getSystemIcon(tmpFile);
                tmpFile.delete();
            }
            catch (Exception e2) {
                defaultIcon_ = UIManager.getIcon("FileView.fileIcon");
            }
            if (!(defaultIcon_ instanceof ImageIcon)) {
                int width = defaultIcon_.getIconWidth();
                int height = defaultIcon_.getIconHeight();
                BufferedImage image = new BufferedImage(width, height, 2);
                Graphics gc = image.getGraphics();
                defaultIcon_.paintIcon(null, gc, 0, 0);
                gc.dispose();
                defaultIcon_ = new ImageIcon(image);
            }
            defaultIcon = (ImageIcon)defaultIcon_;
        }
        return defaultIcon;
    }

    public Dimension getIconSize() {
        ImageIcon defaultIcon = this.getDefaultIcon();
        return defaultIcon == null ? new Dimension(16, 16) : new Dimension(defaultIcon.getIconWidth(), defaultIcon.getIconHeight());
    }

    static FileTypeLauncherInfo getFileTypeLauncherInfo(Integer id2) {
        return idToFileTypeLauncherInfoMap.get(id2);
    }

    private static class CMN_getAllRegisteredExtensions
    extends CommandMessage {
        private CMN_getAllRegisteredExtensions() {
        }

        public Object run(Object[] args) {
            ArrayList<String> extensionList = new ArrayList<String>();
            for (FileTypeLauncherInfo launcherInfo : programToFileTypeLauncherInfoMap.values()) {
                String[] stringArray = launcherInfo.getRegisteredExtensions();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String registeredExtension = stringArray[n3];
                    extensionList.add(registeredExtension);
                    ++n3;
                }
            }
            return extensionList.toArray(new String[0]);
        }
    }

    private static class CMN_getLauncherID
    extends CommandMessage {
        private CMN_getLauncherID() {
        }

        public Object run(Object[] args) {
            String extension = (String)args[0];
            Program program = Program.findProgram(extension);
            if (program == null) {
                return null;
            }
            NativeFileTypeLauncherStatic.initNative();
            FileTypeLauncherInfo fileTypeLauncher = (FileTypeLauncherInfo)programToFileTypeLauncherInfoMap.get(program);
            if (fileTypeLauncher == null && NativeFileTypeLauncherStatic.isProgramValid(program)) {
                fileTypeLauncher = new FileTypeLauncherInfo(program);
                programToFileTypeLauncherInfoMap.put(program, fileTypeLauncher);
            }
            if (fileTypeLauncher != null) {
                if (!hasInitializedExtensions) {
                    fileTypeLauncher.addExtension(extension);
                }
                return fileTypeLauncher.getID();
            }
            return null;
        }
    }

    private static class CMN_getLauncherIDs
    extends CommandMessage {
        private CMN_getLauncherIDs() {
        }

        public Object run(Object[] args) {
            NativeFileTypeLauncherStatic.initNative();
            FileTypeLauncherInfo[] fileTypeLaunchers = programToFileTypeLauncherInfoMap.values().toArray(new FileTypeLauncherInfo[0]);
            Arrays.sort(fileTypeLaunchers, new Comparator<FileTypeLauncherInfo>(){

                @Override
                public int compare(FileTypeLauncherInfo o1, FileTypeLauncherInfo o2) {
                    return o1.getProgram().getName().toLowerCase().compareTo(o2.getProgram().getName().toLowerCase());
                }
            });
            int[] ids = new int[fileTypeLaunchers.length];
            int i2 = 0;
            while (i2 < fileTypeLaunchers.length) {
                ids[i2] = fileTypeLaunchers[i2].getID();
                ++i2;
            }
            return ids;
        }
    }

    private static class CMN_initializeExtensions
    extends CommandMessage {
        private CMN_initializeExtensions() {
        }

        public Object run(Object[] args) {
            String[] stringArray = Program.getExtensions();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String extension = stringArray[n3];
                Program program = Program.findProgram(extension);
                if (program != null) {
                    NativeFileTypeLauncherStatic.initNative();
                    FileTypeLauncherInfo fileTypeLauncherInfo = (FileTypeLauncherInfo)programToFileTypeLauncherInfoMap.get(program);
                    if (fileTypeLauncherInfo == null && NativeFileTypeLauncherStatic.isProgramValid(program)) {
                        fileTypeLauncherInfo = new FileTypeLauncherInfo(program);
                        programToFileTypeLauncherInfoMap.put(program, fileTypeLauncherInfo);
                    }
                    if (fileTypeLauncherInfo != null) {
                        fileTypeLauncherInfo.addExtension(extension);
                    }
                }
                ++n3;
            }
            return null;
        }
    }

    private static class CMN_initializeLaunchers
    extends CommandMessage {
        private CMN_initializeLaunchers() {
        }

        public Object run(Object[] args) {
            Program[] programArray = Program.getPrograms();
            int n2 = programArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Program program = programArray[n3];
                if (!programToFileTypeLauncherInfoMap.containsKey(program) && NativeFileTypeLauncherStatic.isProgramValid(program) && program.getImageData() != null) {
                    programToFileTypeLauncherInfoMap.put(program, new FileTypeLauncherInfo(program));
                }
                ++n3;
            }
            return null;
        }
    }

    static class FileTypeLauncherInfo {
        public static int nextID = 1;
        private int id = nextID++;
        private Program program;
        private List<String> registeredExtensionList;
        private boolean isIconInitialized;
        private ImageIcon icon;

        public FileTypeLauncherInfo(Program program) {
            this.program = program;
            idToFileTypeLauncherInfoMap.put(this.getID(), this);
        }

        private void addExtension(String extension) {
            if (this.registeredExtensionList == null) {
                this.registeredExtensionList = new ArrayList<String>(1);
            }
            if (!this.registeredExtensionList.contains(extension)) {
                this.registeredExtensionList.add(extension);
            }
        }

        public int getID() {
            return this.id;
        }

        public String[] getRegisteredExtensions() {
            return this.registeredExtensionList == null ? new String[]{} : this.registeredExtensionList.toArray(new String[0]);
        }

        public Program getProgram() {
            return this.program;
        }

        public ImageIcon getIcon() {
            if (!this.isIconInitialized) {
                this.isIconInitialized = true;
                ImageData imageData = this.program.getImageData();
                this.icon = imageData == null ? null : new ImageIcon(SWTUtils.convertSWTImage(imageData));
            }
            return this.icon;
        }
    }
}

