/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.NetworkURLClassLoader;
import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeSwing;
import chrriis.dj.nativeswing.swtimpl.ApplicationMessageHandler;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceConfiguration;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceListener;
import chrriis.dj.nativeswing.swtimpl.PeerVMProcessFactory;
import chrriis.dj.nativeswing.swtimpl.core.DefaultPeerVMProcessFactory;
import chrriis.dj.nativeswing.swtimpl.core.InProcessMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.OutProcessIOMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.OutProcessSocketsMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import chrriis.dj.nativeswing.swtimpl.internal.ISWTNativeInterface;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWTNativeInterface
extends NativeInterface
implements ISWTNativeInterface {
    private static final boolean IS_SYNCING_MESSAGES = Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_SYNCMESSAGES.get());
    private static boolean isOpen;
    private static volatile NativeInterfaceConfiguration nativeInterfaceConfiguration;
    private volatile boolean isInitialized;
    private boolean isInProcess;
    private static final Object OPEN_CLOSE_SYNC_LOCK;
    private static final Object OPEN_STATE_LOCK;
    private static MessagingInterface messagingInterface;
    private static volatile Display display;
    private static volatile boolean isEventPumpRunning;
    private EventListenerList listenerList = new EventListenerList();
    private ApplicationMessageHandler applicationMessageHandler;
    private static volatile long lastProcessTime;

    static {
        OPEN_CLOSE_SYNC_LOCK = new Object();
        OPEN_STATE_LOCK = new Object();
        lastProcessTime = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return SWTNativeInterface.isOpen() && messagingInterface.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen_() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return isOpen;
        }
    }

    private void checkOpen() {
        if (!SWTNativeInterface.isOpen()) {
            throw new IllegalStateException("The native interface is not open! Please refer to the instructions to set it up properly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close_() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            if (!SWTNativeInterface.isOpen()) {
                return;
            }
            Object object2 = OPEN_STATE_LOCK;
            synchronized (object2) {
                isOpen = false;
                messagingInterface.destroy();
                messagingInterface = null;
            }
            NativeInterfaceListener[] nativeInterfaceListenerArray = SWTNativeInterface.getNativeInterfaceListeners();
            int n2 = nativeInterfaceListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n3];
                listener.nativeInterfaceClosed();
                ++n3;
            }
        }
    }

    public NativeInterfaceConfiguration getConfiguration_() {
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = SWTNativeInterface.createConfiguration();
        }
        return nativeInterfaceConfiguration;
    }

    private void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInitialized_() {
        return this.isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInProcess_() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            return this.isInProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize_() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            String inProcessProperty;
            int n2;
            if (SWTNativeInterface.isInitialized()) {
                return;
            }
            if (Boolean.parseBoolean(NSSystemPropertySWT.DEPENDENCIES_CHECKVERSIONS.get("true")) && SWT.getVersion() < 4332) {
                throw new IllegalStateException("The version of SWT that is required is 4.3 or later!");
            }
            if (nativeInterfaceConfiguration == null) {
                nativeInterfaceConfiguration = SWTNativeInterface.createConfiguration();
            }
            if (Utils.IS_MAC && !"applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get())) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                n2 = stackTraceElementArray.length;
                int n3 = 0;
                block7: while (n3 < n2) {
                    StackTraceElement ste = stackTraceElementArray[n3];
                    try {
                        Class<?> steClass;
                        Class<?> clazz = steClass = Class.forName(ste.getClassName());
                        while (clazz != null) {
                            if (clazz.getName().equals("java.awt.Component")) {
                                System.err.println("On Mac, \"NativeInterface.initialize()\"/\"NativeInterface.open()\" should not be called after AWT static initializers have run, otherwise there can be all sorts of side effects (non-functional modal dialogs, etc.). Generally, the problem is when the \"main(String[])\" method is located inside an AWT component subclass and the fix is to move that main method to a standalone class. The problematic class here is \"" + steClass.getName() + "\"");
                                break block7;
                            }
                            clazz = clazz.getSuperclass();
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    ++n3;
                }
            }
            this.isInProcess = (inProcessProperty = NSSystemPropertySWT.INTERFACE_INPROCESS.get()) != null ? Boolean.parseBoolean(inProcessProperty) : Utils.IS_MAC;
            try {
                NativeInterfaceListener[] nativeInterfaceListenerArray = SWTNativeInterface.getNativeInterfaceListeners();
                int n4 = nativeInterfaceListenerArray.length;
                n2 = 0;
                while (n2 < n4) {
                    NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                    listener.nativeInterfaceInitialized();
                    ++n2;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (this.isInProcess_()) {
                InProcess.initialize();
            } else {
                OutProcess.initialize();
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent e2) {
                    KeyEvent ke = (KeyEvent)e2;
                    if (ke.getID() == 401 && ke.getKeyCode() == 114 && ke.isControlDown() && ke.isAltDown() && ke.isShiftDown()) {
                        SWTNativeInterface.printStackTraces();
                    }
                }
            }, 8L);
            this.isInitialized = true;
        }
    }

    public void printStackTraces_() {
        Utils.printStackTraces();
        this.printPeerStackTrace(System.err);
    }

    public void printStackTraces_(PrintStream printStream) {
        Utils.printStackTraces(printStream);
        this.printPeerStackTrace(printStream);
    }

    public void printStackTraces_(PrintWriter printWriter) {
        Utils.printStackTraces(printWriter);
        this.printPeerStackTrace(printWriter);
    }

    private void printPeerStackTrace(final Object o2) {
        if (!this.isInProcess_() && SWTNativeInterface.isOpen()) {
            if (SWTNativeInterface.isUIThread(false)) {
                Thread t2 = new Thread("NativeSwing stack traces dump"){

                    public void run() {
                        SWTNativeInterface.this.printPeerStackTrace(o2);
                    }
                };
                t2.start();
                try {
                    t2.join();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                boolean isToConsole = o2 == null;
                CMN_printStackTraces message = new CMN_printStackTraces();
                SWTNativeInterface.setMessageArgs(message, isToConsole);
                String s2 = (String)this.syncSend_(true, message);
                if (!isToConsole) {
                    String descriptor = "---- NativeSwing[" + this.getMessagingInterface(false).getPID() + "] Peer VM Stack Traces ----" + Utils.LINE_SEPARATOR;
                    if (o2 instanceof PrintStream) {
                        PrintStream ps = (PrintStream)o2;
                        ps.append(descriptor);
                        ps.append(s2);
                    } else if (o2 instanceof PrintWriter) {
                        PrintWriter pw = (PrintWriter)o2;
                        pw.append(descriptor);
                        pw.append(s2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open_() {
        Object object = OPEN_CLOSE_SYNC_LOCK;
        synchronized (object) {
            if (SWTNativeInterface.isOpen()) {
                return;
            }
            SWTNativeInterface.initialize();
            this.loadClipboardDebuggingProperties();
            if (this.isInProcess_()) {
                InProcess.createInProcessCommunicationChannel();
            } else {
                OutProcess.createOutProcessCommunicationChannel();
            }
            try {
                NativeInterfaceListener[] nativeInterfaceListenerArray = SWTNativeInterface.getNativeInterfaceListeners();
                int n2 = nativeInterfaceListenerArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    NativeInterfaceListener listener = nativeInterfaceListenerArray[n3];
                    listener.nativeInterfaceOpened();
                    ++n3;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyKilled() {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            isOpen = false;
            messagingInterface = null;
        }
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = SWTNativeInterface.getNativeInterfaceListeners();
            int n2 = nativeInterfaceListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n3];
                listener.nativeInterfaceClosed();
                ++n3;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (!OutProcess.isNativeSide() && nativeInterfaceConfiguration.isNativeSideRespawnedOnError()) {
            OutProcess.createOutProcessCommunicationChannel();
            return true;
        }
        return false;
    }

    public void notifyRespawned() {
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = SWTNativeInterface.getNativeInterfaceListeners();
            int n2 = nativeInterfaceListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n3];
                listener.nativeInterfaceOpened();
                ++n3;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public Object syncSend_(boolean isTargetNativeSide, Message message) {
        this.checkOpen();
        if (message instanceof LocalMessage) {
            LocalMessage localMessage = (LocalMessage)message;
            return SWTNativeInterface.runMessageCommand(localMessage);
        }
        return this.getMessagingInterface(!isTargetNativeSide).syncSend(message);
    }

    public void asyncSend_(boolean isTargetNativeSide, Message message) {
        if (IS_SYNCING_MESSAGES) {
            this.syncSend_(isTargetNativeSide, message);
        } else {
            this.checkOpen();
            if (message instanceof LocalMessage) {
                LocalMessage localMessage = (LocalMessage)message;
                SWTNativeInterface.runMessageCommand(localMessage);
                return;
            }
            this.getMessagingInterface(!isTargetNativeSide).asyncSend(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessagingInterface getMessagingInterface(boolean isNativeSide) {
        Object object = OPEN_STATE_LOCK;
        synchronized (object) {
            if (this.isInProcess_()) {
                if (isNativeSide) {
                    InProcessMessagingInterface.SWTInProcessMessagingInterface swtInProcessMessagingInterface = (InProcessMessagingInterface.SWTInProcessMessagingInterface)((InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface).getMirrorMessagingInterface();
                    return swtInProcessMessagingInterface;
                }
                InProcessMessagingInterface.SwingInProcessMessagingInterface swingInProcessMessagingInterface = (InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface;
                return swingInProcessMessagingInterface;
            }
            if (isNativeSide) {
                if (messagingInterface instanceof OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface) {
                    OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface swtOutProcessSocketsMessagingInterface = (OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface)messagingInterface;
                    return swtOutProcessSocketsMessagingInterface;
                }
                OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface swtOutProcessIOMessagingInterface = (OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface)messagingInterface;
                return swtOutProcessIOMessagingInterface;
            }
            if (messagingInterface instanceof OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface) {
                OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface swingOutProcessSocketsMessagingInterface = (OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface)messagingInterface;
                return swingOutProcessSocketsMessagingInterface;
            }
            OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface swingOutProcessIOMessagingInterface = (OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface)messagingInterface;
            return swingOutProcessIOMessagingInterface;
        }
    }

    public Display getDisplay() {
        return display;
    }

    public boolean isOutProcessNativeSide_() {
        return OutProcess.isNativeSide();
    }

    public boolean isUIThread_(boolean isNativeSide) {
        if (!this.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        return this.getMessagingInterface(isNativeSide).isUIThread();
    }

    public int getInterfaceID(boolean isNativeSide) {
        if (!this.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        return this.getMessagingInterface(isNativeSide).getPID();
    }

    public void checkUIThread(boolean isNativeSide) {
        if (!this.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        this.getMessagingInterface(isNativeSide).checkUIThread();
    }

    public boolean isEventPumpRunning_() {
        return isEventPumpRunning;
    }

    public void runEventPump_() {
        if (!SWTNativeInterface.isInitialized()) {
            throw new IllegalStateException("Cannot run the event pump when the interface is not initialized!");
        }
        if (isEventPumpRunning) {
            throw new IllegalStateException("runEventPump was already called and can only be called once (the first call should be at the end of the main method)!");
        }
        isEventPumpRunning = true;
        this.startAutoShutdownThread();
        if (this.isInProcess_()) {
            InProcess.runEventPump();
        } else {
            OutProcess.runEventPump();
        }
    }

    private void startAutoShutdownThread() {
        final Thread displayThread = display == null ? null : display.getThread();
        final Thread currentThread = Thread.currentThread();
        Thread autoShutdownThread = new Thread("NativeSwing Auto-Shutdown"){
            protected Thread[] activeThreads;
            {
                super($anonymous0);
                this.activeThreads = new Thread[1024];
            }

            public void run() {
                boolean isAlive = true;
                while (isAlive) {
                    ThreadGroup group;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ThreadGroup parentGroup = group = Thread.currentThread().getThreadGroup();
                    while ((parentGroup = parentGroup.getParent()) != null) {
                        group = parentGroup;
                    }
                    isAlive = false;
                    int i2 = group.enumerate(this.activeThreads, true) - 1;
                    while (i2 >= 0) {
                        Thread t2 = this.activeThreads[i2];
                        if (!isAlive && t2 != displayThread && t2 != currentThread && !t2.isDaemon() && t2.isAlive()) {
                            isAlive = true;
                        }
                        this.activeThreads[i2] = null;
                        --i2;
                    }
                }
                if (display == null) {
                    isEventPumpRunning = false;
                } else if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            isEventPumpRunning = false;
                        }
                    });
                }
            }
        };
        autoShutdownThread.setDaemon(true);
        autoShutdownThread.start();
    }

    public void addNativeInterfaceListener_(NativeInterfaceListener listener) {
        this.listenerList.add(NativeInterfaceListener.class, listener);
    }

    public void removeNativeInterfaceListener_(NativeInterfaceListener listener) {
        this.listenerList.remove(NativeInterfaceListener.class, listener);
    }

    public NativeInterfaceListener[] getNativeInterfaceListeners_() {
        return (NativeInterfaceListener[])this.listenerList.getListeners(NativeInterfaceListener.class);
    }

    public void setApplicationMessageHandler_(ApplicationMessageHandler applicationMessageHandler) {
        this.applicationMessageHandler = applicationMessageHandler;
    }

    public ApplicationMessageHandler getApplicationMessageHandler() {
        return this.applicationMessageHandler;
    }

    private static void handleQuit() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWTNativeInterface.handleQuit();
                }
            });
            return;
        }
        ApplicationMessageHandler applicationMessageHandler = SWTNativeInterface.getInstance().getApplicationMessageHandler();
        if (applicationMessageHandler == null) {
            System.exit(-1324);
        } else {
            applicationMessageHandler.handleQuit();
        }
    }

    private static void destroyControls() {
        if (display != null && !display.isDisposed()) {
            if (display.getThread() != Thread.currentThread()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        SWTNativeInterface.destroyControls();
                    }
                });
                return;
            }
            Control[] controlArray = SWTNativeComponent.getControls();
            int n2 = controlArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Control control = controlArray[n3];
                Shell shell = control.isDisposed() ? null : control.getShell();
                try {
                    if (shell != null) {
                        shell.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                control.dispose();
                ++n3;
            }
            try {
                display.dispose();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    public static SWTNativeInterface getInstance() {
        return (SWTNativeInterface)NativeInterface.getInstance();
    }

    protected static int getMessageID(Message message) {
        return NativeInterface.getMessageID(message);
    }

    protected static boolean isMessageValid(Message message) {
        return NativeInterface.isMessageValid(message);
    }

    protected static Object runMessageCommand(LocalMessage commandMessage) {
        return NativeInterface.runMessageCommand(commandMessage);
    }

    protected static Object runMessageCommand(CommandMessage commandMessage) throws Exception {
        return NativeInterface.runMessageCommand(commandMessage);
    }

    protected static boolean isMessageSyncExec(Message message) {
        return NativeInterface.isMessageSyncExec(message);
    }

    protected static void setMessageSyncExec(Message message, boolean isSyncExec) {
        NativeInterface.setMessageSyncExec(message, isSyncExec);
    }

    protected static void setMessageArgs(CommandMessage message, Object ... args) {
        NativeInterface.setMessageArgs(message, args);
    }

    protected static void computeMessageID(Message message, boolean isTargetNativeSide) {
        NativeInterface.computeMessageID(message, isTargetNativeSide);
    }

    protected static void setMessageUI(Message message, boolean isUI) {
        NativeInterface.setMessageUI(message, isUI);
    }

    protected static boolean isMessageUI(Message message) {
        return NativeInterface.isMessageUI(message);
    }

    public void main_(String[] args) throws Exception {
        OutProcess.runNativeSide(args);
    }

    public static /* bridge */ /* synthetic */ NativeInterface getInstance() {
        return SWTNativeInterface.getInstance();
    }

    private static class CMN_printStackTraces
    extends CommandMessage {
        private CMN_printStackTraces() {
        }

        public Object run(Object[] args) {
            boolean isToConsole = (Boolean)args[0];
            if (isToConsole) {
                Utils.printStackTraces();
                return null;
            }
            StringWriter sw = new StringWriter();
            Utils.printStackTraces(new PrintWriter(sw));
            return sw.toString();
        }
    }

    static class InProcess {
        private static volatile int pid;

        InProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void createInProcessCommunicationChannel() {
            Object object = OPEN_STATE_LOCK;
            synchronized (object) {
                SWTNativeInterface.messagingInterface = InProcess.createInProcessMessagingInterface();
                isOpen = true;
            }
        }

        private static void initialize() {
            Device.DEBUG = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICE_DEBUG.get());
            if (Utils.IS_MAC && "applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get())) {
                NativeSwing.initialize();
                InProcess.runWithMacExecutor(new Runnable(){

                    public void run() {
                        InProcess.findSWTDisplay();
                    }
                });
            } else {
                try {
                    InProcess.findSWTDisplay();
                }
                catch (SWTException e2) {
                    if (Utils.IS_MAC) {
                        InProcess.runWithMacExecutor(new Runnable(){

                            public void run() {
                                InProcess.findSWTDisplay();
                            }
                        });
                    }
                    throw e2;
                }
                NativeSwing.initialize();
            }
            if (!Utils.IS_MAC || Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_INPROCESS_FORCESHUTDOWNHOOK.get())) {
                Runtime.getRuntime().addShutdownHook(new Thread("NativeSwing Shutdown Hook"){

                    public void run() {
                        SWTNativeInterface.destroyControls();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runWithMacExecutor(final Runnable runnable) {
            Executor mainQueueExecutor;
            try {
                Object dispatch = Class.forName("com.apple.concurrent.Dispatch").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                mainQueueExecutor = (Executor)dispatch.getClass().getMethod("getNonBlockingMainQueueExecutor", new Class[0]).invoke(dispatch, new Object[0]);
            }
            catch (Exception e2) {
                throw new IllegalStateException("Failed to use the Mac Dispatch executor. This may happen if the version of Java that is used is too old.", e2);
            }
            final AtomicBoolean isExecutorCallComplete = new AtomicBoolean(false);
            final AtomicReference exceptionReference = new AtomicReference();
            AtomicBoolean atomicBoolean = isExecutorCallComplete;
            synchronized (atomicBoolean) {
                mainQueueExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block14: {
                            try {
                                try {
                                    runnable.run();
                                }
                                catch (Throwable t2) {
                                    exceptionReference.set(t2);
                                    AtomicBoolean atomicBoolean = isExecutorCallComplete;
                                    synchronized (atomicBoolean) {
                                        isExecutorCallComplete.set(true);
                                        isExecutorCallComplete.notify();
                                        break block14;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                AtomicBoolean atomicBoolean = isExecutorCallComplete;
                                synchronized (atomicBoolean) {
                                    isExecutorCallComplete.set(true);
                                    isExecutorCallComplete.notify();
                                }
                                throw throwable;
                            }
                            AtomicBoolean atomicBoolean = isExecutorCallComplete;
                            synchronized (atomicBoolean) {
                                isExecutorCallComplete.set(true);
                                isExecutorCallComplete.notify();
                            }
                        }
                    }
                });
                while (!isExecutorCallComplete.get()) {
                    try {
                        isExecutorCallComplete.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Throwable throwable = (Throwable)exceptionReference.get();
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }

        private static void findSWTDisplay() {
            SWTNativeInterface.display = Display.getCurrent();
            if (display == null && Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_INPROCESS_USEEXTERNALSWTDISPLAY.get())) {
                SWTNativeInterface.display = Display.getDefault();
                if (display.getThread() == Thread.currentThread()) {
                    display.dispose();
                    SWTNativeInterface.display = null;
                    NSSystemPropertySWT.INTERFACE_INPROCESS_USEEXTERNALSWTDISPLAY.set("false");
                }
            }
            if (display == null) {
                DeviceData data = new DeviceData();
                data.debug = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICEDATA_DEBUG.get());
                data.tracking = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICEDATA_TRACKING.get());
                SWTNativeInterface.display = new Display(data);
            }
            display.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    SWTNativeInterface.handleQuit();
                }
            });
        }

        private static MessagingInterface createInProcessMessagingInterface() {
            int pid_ = ++pid;
            return new InProcessMessagingInterface.SWTInProcessMessagingInterface(display, pid_).getMirrorMessagingInterface();
        }

        static void runEventPump() {
            if (Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_INPROCESS_USEEXTERNALSWTDISPLAY.get()) && display.getThread() != Thread.currentThread()) {
                return;
            }
            if (Utils.IS_MAC && display.getThread() != Thread.currentThread()) {
                InProcess.runWithMacExecutor(new Runnable(){

                    public void run() {
                        InProcess.runSWTEventPump();
                    }
                });
                return;
            }
            InProcess.runSWTEventPump();
        }

        private static void runSWTEventPump() {
            while (isEventPumpRunning) {
                try {
                    if (display.isDisposed()) {
                        isEventPumpRunning = false;
                        continue;
                    }
                    if (display.readAndDispatch() || !isEventPumpRunning) continue;
                    display.sleep();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
            display.dispose();
        }
    }

    static class OutProcess {
        private static final boolean IS_PROCESS_IO_CHANNEL_MODE = "processio".equals(NSSystemPropertySWT.INTERFACE_OUTPROCESS_COMMUNICATION.get());
        private static volatile int pid;

        OutProcess() {
        }

        private static void initialize() {
            NativeSwing.initialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean isOpen_;
                    Object object = OPEN_STATE_LOCK;
                    synchronized (object) {
                        isOpen_ = isOpen;
                    }
                    if (isOpen_) {
                        new CMN_destroyControls().asyncExec(true, new Object[0]);
                    }
                }
            });
        }

        static boolean isNativeSide() {
            return display != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void createOutProcessCommunicationChannel() {
            Object object = OPEN_STATE_LOCK;
            synchronized (object) {
                int i2 = 2;
                while (i2 >= 0) {
                    try {
                        SWTNativeInterface.messagingInterface = OutProcess.createOutProcessMessagingInterface();
                        break;
                    }
                    catch (RuntimeException e2) {
                        if (i2 == 0) {
                            throw e2;
                        }
                        --i2;
                    }
                }
                isOpen = true;
            }
            Properties nativeProperties = new Properties();
            Properties properties = System.getProperties();
            for (Object key : properties.keySet()) {
                Object value;
                if (!(key instanceof String) || !((value = properties.get(key)) instanceof String)) continue;
                nativeProperties.setProperty((String)key, (String)value);
            }
            new CMN_setProperties().syncExec(true, nativeProperties);
        }

        /*
         * WARNING - void declaration
         */
        private static Process createProcess(String localHostAddress, int port, int pid) {
            String mainClass;
            String[] flags;
            String swtLibraryPath;
            String javaLibraryPath;
            String[] property;
            int n2;
            int n3;
            String[] nativeClassPathReferenceResources;
            ArrayList<String> classPathList = new ArrayList<String>();
            ArrayList<Object> referenceList = new ArrayList<Object>();
            Class[] nativeClassPathReferenceClasses = SWTNativeInterface.getNativeClassPathReferenceClasses(nativeInterfaceConfiguration);
            if (nativeClassPathReferenceClasses != null) {
                referenceList.addAll(Arrays.asList(nativeClassPathReferenceClasses));
            }
            if ((nativeClassPathReferenceResources = SWTNativeInterface.getNativeClassPathReferenceResources(nativeInterfaceConfiguration)) != null) {
                referenceList.addAll(Arrays.asList(nativeClassPathReferenceResources));
            }
            ArrayList<String> optionalReferenceList = new ArrayList<String>();
            referenceList.add(NativeSwing.class);
            referenceList.add(NativeInterface.class);
            referenceList.add(SWTNativeInterface.class);
            if (SWTNativeInterface.class.getClassLoader() != NativeInterface.class.getClassLoader()) {
                WebServer.getDefaultWebServer().addReferenceClassLoader(SWTNativeInterface.class.getClassLoader());
            }
            referenceList.add("org/eclipse/swt/widgets/Display.class");
            optionalReferenceList.add("org/mozilla/xpcom/Mozilla.class");
            optionalReferenceList.add("org/mozilla/interfaces/nsIWebBrowser.class");
            for (String optionalReference : optionalReferenceList) {
                if (optionalReference.startsWith("/")) {
                    optionalReference = optionalReference.substring(1);
                }
                if (SWTNativeInterface.class.getResource(String.valueOf('/') + optionalReference) == null) continue;
                referenceList.add(optionalReference);
            }
            boolean isProxyClassLoaderUsed = Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_FORCEPROXYCLASSLOADER.get());
            if (!isProxyClassLoaderUsed) {
                for (Object e2 : referenceList) {
                    File clazzClassPath;
                    if (e2 instanceof Class) {
                        clazzClassPath = Utils.getClassPathFile((Class)e2);
                    } else {
                        String resource = (String)e2;
                        clazzClassPath = Utils.getClassPathFile(resource);
                        if (SWTNativeInterface.class.getResource(String.valueOf('/') + resource) == null) {
                            throw new IllegalStateException("A resource that is needed in the classpath is missing: " + e2);
                        }
                    }
                    if (clazzClassPath != null) {
                        String path = clazzClassPath.getAbsolutePath();
                        if (classPathList.contains(path)) continue;
                        classPathList.add(path);
                        continue;
                    }
                    isProxyClassLoaderUsed = true;
                }
            }
            if (isProxyClassLoaderUsed) {
                classPathList.clear();
                File file = new File(SystemProperty.JAVA_IO_TMPDIR.get(), ".djnativeswing/classpath");
                Utils.deleteAll(file);
                String classPath = String.valueOf(NetworkURLClassLoader.class.getName().replace('.', '/')) + ".class";
                File mainClassFile = new File(file, classPath);
                mainClassFile.getParentFile().mkdirs();
                if (!mainClassFile.exists()) {
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(mainClassFile));
                        BufferedInputStream in = new BufferedInputStream(SWTNativeInterface.class.getResourceAsStream("/" + classPath));
                        byte[] bytes = new byte[1024];
                        while ((n3 = in.read(bytes)) != -1) {
                            void n4;
                            out.write(bytes, 0, (int)n4);
                        }
                        in.close();
                        out.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    mainClassFile.deleteOnExit();
                }
                classPathList.add(file.getAbsolutePath());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> systemPropertiesMap = new HashMap<String, String>();
            String[] peerVMParams = SWTNativeInterface.getPeerVMParams(nativeInterfaceConfiguration);
            boolean isJavaLibraryPathProperySpecified = false;
            boolean isSWTLibraryPathProperySpecified = false;
            if (peerVMParams != null) {
                String[] stringArray = peerVMParams;
                n2 = peerVMParams.length;
                n3 = 0;
                while (n3 < n2) {
                    String peerVMParam = stringArray[n3];
                    if (peerVMParam.startsWith("-D")) {
                        property = peerVMParam.substring(2);
                        int index = property.indexOf(61);
                        String propertyKey = property.substring(0, index);
                        String propertyValue = property.substring(index + 1);
                        systemPropertiesMap.put(propertyKey, propertyValue);
                        if (SystemProperty.JAVA_LIBRARY_PATH.getName().equals(propertyKey)) {
                            isJavaLibraryPathProperySpecified = true;
                        } else if ("swt.library.path".equals(propertyKey)) {
                            isSWTLibraryPathProperySpecified = true;
                        }
                    } else {
                        arrayList.add(peerVMParam);
                    }
                    ++n3;
                }
            }
            if (!isJavaLibraryPathProperySpecified && (javaLibraryPath = SystemProperty.JAVA_LIBRARY_PATH.get()) != null) {
                systemPropertiesMap.put(SystemProperty.JAVA_LIBRARY_PATH.getName(), javaLibraryPath);
            }
            if (!isSWTLibraryPathProperySpecified && (swtLibraryPath = NSSystemPropertySWT.SWT_LIBRARY_PATH.get()) != null) {
                systemPropertiesMap.put(NSSystemPropertySWT.SWT_LIBRARY_PATH.getName(), swtLibraryPath);
            }
            property = flags = new String[]{NSSystemPropertySWT.INTERFACE_SYNCMESSAGES.getName(), NSSystemPropertySWT.INTERFACE_DEBUG_PRINTMESSAGES.getName(), NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTARTMESSAGE.getName(), NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTOPMESSAGE.getName(), NSSystemPropertySWT.SWT_DEVICE_DEBUG.getName(), NSSystemPropertySWT.SWT_DEVICEDATA_DEBUG.getName(), NSSystemPropertySWT.SWT_DEVICEDATA_TRACKING.getName()};
            int n5 = flags.length;
            n2 = 0;
            while (n2 < n5) {
                String flag = property[n2];
                if (Boolean.parseBoolean(System.getProperty(flag))) {
                    systemPropertiesMap.put(flag, "true");
                }
                ++n2;
            }
            systemPropertiesMap.put(NSSystemProperty.LOCALHOSTADDRESS.getName(), localHostAddress);
            ArrayList<String> mainClassParameterList = new ArrayList<String>();
            if (isProxyClassLoaderUsed) {
                mainClass = NetworkURLClassLoader.class.getName();
                mainClassParameterList.add(WebServer.getDefaultWebServer().getClassPathResourceURL("", ""));
                mainClassParameterList.add(NativeInterface.class.getName());
            } else {
                mainClass = NativeInterface.class.getName();
            }
            mainClassParameterList.add(String.valueOf(pid));
            mainClassParameterList.add(String.valueOf(port));
            PeerVMProcessFactory peerVMProcessFactory = nativeInterfaceConfiguration.getPeerVMProcessFactory();
            if (peerVMProcessFactory == null) {
                peerVMProcessFactory = new DefaultPeerVMProcessFactory();
            }
            Process p2 = null;
            try {
                p2 = peerVMProcessFactory.createProcess(classPathList.toArray(new String[0]), systemPropertiesMap, arrayList.toArray(new String[0]), mainClass, mainClassParameterList.toArray(new String[0]));
            }
            catch (Exception e3) {
                throw new IllegalStateException("Failed to spawn the peer VM!", e3);
            }
            if (p2 == null) {
                throw new IllegalStateException("Failed to spawn the peer VM!");
            }
            return p2;
        }

        private static MessagingInterface createOutProcessMessagingInterface() {
            Process p2;
            int port;
            boolean isProcessIOChannelMode;
            String localHostAddress = Utils.getLocalHostAddress();
            if (localHostAddress == null) {
                throw new IllegalStateException("Failed to find a suitable local host address to communicate with a spawned VM!");
            }
            boolean isCreatingProcess = Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_CREATE.get("true"));
            boolean bl2 = isProcessIOChannelMode = IS_PROCESS_IO_CHANNEL_MODE && isCreatingProcess;
            if (isProcessIOChannelMode) {
                port = 0;
            } else {
                port = Integer.parseInt(NSSystemPropertySWT.INTERFACE_PORT.get("-1"));
                if (port <= 0) {
                    ServerSocket serverSocket;
                    try {
                        serverSocket = new ServerSocket();
                        serverSocket.setReuseAddress(false);
                        serverSocket.bind(new InetSocketAddress(InetAddress.getByName(localHostAddress), 0));
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    port = serverSocket.getLocalPort();
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
            }
            int pid_ = ++pid;
            if (isCreatingProcess) {
                p2 = OutProcess.createProcess(localHostAddress, port, pid_);
                if (!isProcessIOChannelMode) {
                    OutProcess.connectStream(System.out, p2.getInputStream(), "out", pid_);
                }
                OutProcess.connectStream(System.err, p2.getErrorStream(), "err", pid_);
            } else {
                p2 = null;
            }
            if (isProcessIOChannelMode) {
                return new OutProcessIOMessagingInterface.SwingOutProcessIOMessagingInterface(p2.getInputStream(), p2.getOutputStream(), false, p2, pid_);
            }
            Exception exception = null;
            Socket socket = null;
            long peerVMConnectionTimeout = Integer.parseInt(NSSystemPropertySWT.INTERFACE_OUTPROCESS_CONNECTIONTIMEOUT.get("10000"));
            long startTime = System.currentTimeMillis();
            while (true) {
                if (p2 != null) {
                    try {
                        p2.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                try {
                    socket = new Socket(localHostAddress, port);
                    exception = null;
                }
                catch (Exception e3) {
                    exception = e3;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - startTime < peerVMConnectionTimeout) continue;
                }
                break;
            }
            if (socket == null) {
                if (p2 != null) {
                    p2.destroy();
                }
                if (exception == null) {
                    throw new IllegalStateException("Failed to connect to spawned VM! The native side process was already terminated.");
                }
                throw new IllegalStateException("Failed to connect to spawned VM!", exception);
            }
            return new OutProcessSocketsMessagingInterface.SwingOutProcessSocketsMessagingInterface(socket, false, p2, pid_);
        }

        private static void connectStream(final PrintStream out, InputStream in, String name, int pid) {
            final BufferedInputStream bin = new BufferedInputStream(in);
            Thread streamThread = new Thread("NativeSwing[" + pid + "] " + name + " Stream Connector", pid){
                private IOStreamFormatter byteProcessor;
                {
                    super($anonymous0);
                    this.byteProcessor = new IOStreamFormatter(n2);
                }

                public void run() {
                    try {
                        int i2;
                        byte[] bytes = new byte[1024];
                        while ((i2 = bin.read(bytes)) != -1) {
                            byte[] result = this.byteProcessor.process(bytes, 0, i2);
                            try {
                                out.write(result);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            streamThread.setDaemon(true);
            streamThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        static void runNativeSide(String[] args) throws IOException {
            block33: {
                pid = Integer.parseInt(args[0]);
                if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTARTMESSAGE.get())) {
                    System.err.println("Starting peer VM #" + pid);
                }
                var2_2 = SWTNativeInterface.access$1();
                synchronized (var2_2) {
                    SWTNativeInterface.access$3(true);
                }
                port = Integer.parseInt(args[1]);
                isProcessIOChannelMode = port <= 0;
                socket = null;
                if (!isProcessIOChannelMode) {
                    serverSocket = null;
                    startTime = System.currentTimeMillis();
                    while (true) {
                        try {
                            serverSocket = new ServerSocket();
                            serverSocket.setReuseAddress(true);
                            serverSocket.bind(new InetSocketAddress(Utils.getLocalHostAddress(), port));
                            exception = null;
                        }
                        catch (IOException e) {
                            exception = e;
                            if (serverSocket != null) {
                                try {
                                    serverSocket.close();
                                }
                                catch (Exception var10_14) {
                                    // empty catch block
                                }
                            }
                            serverSocket = null;
                            try {
                                Thread.sleep(200L);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (System.currentTimeMillis() - startTime < 5000L) continue;
                        }
                        break;
                    }
                    if (serverSocket == null) {
                        if (exception == null) {
                            throw new IllegalStateException("Failed to create the server socket for native side communication!");
                        }
                        throw exception;
                    }
                    serverSocket_ = serverSocket;
                    if (!Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_KEEPALIVE.get())) {
                        shutdownThread = new Thread("NativeSwing Shutdown", (ServerSocket)serverSocket_){
                            private final /* synthetic */ ServerSocket val$serverSocket_;
                            {
                                this.val$serverSocket_ = serverSocket;
                                super($anonymous0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                boolean isNull;
                                try {
                                    3.sleep(10000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Object object = OPEN_STATE_LOCK;
                                synchronized (object) {
                                    isNull = messagingInterface == null;
                                }
                                if (isNull) {
                                    try {
                                        this.val$serverSocket_.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        };
                        shutdownThread.setDaemon(true);
                        shutdownThread.start();
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            Thread t2 = new Thread("Forced VM termination thread"){

                                public void run() {
                                    try {
                                        1.sleep(20000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    Runtime.getRuntime().halt(-1);
                                }
                            };
                            t2.setDaemon(false);
                            t2.start();
                            SWTNativeInterface.destroyControls();
                        }
                    });
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("The native side did not receive an incoming connection!", e);
                    }
                }
                Device.DEBUG = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICE_DEBUG.get());
                data = new DeviceData();
                data.debug = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICEDATA_DEBUG.get());
                data.tracking = Boolean.parseBoolean(NSSystemPropertySWT.SWT_DEVICEDATA_TRACKING.get());
                SWTNativeInterface.access$5(new Display(data));
                SWTNativeInterface.access$6().addListener(21, new Listener(){

                    public void handleEvent(Event event) {
                        new CMJ_handleClosedDisplay().asyncExec(false, new Object[0]);
                    }
                });
                Display.setAppName("DJ Native Swing");
                if (!isProcessIOChannelMode) break block33;
                sysout = System.out;
                sysin = System.in;
                outInterface = new OutProcessIOMessagingInterface.SWTOutProcessIOMessagingInterface(sysin, sysout, true, SWTNativeInterface.access$6(), pid);
                serverSocket_ = SWTNativeInterface.access$1();
                synchronized (serverSocket_) {
                    SWTNativeInterface.access$2(outInterface);
                }
                System.setIn(new InputStream(){

                    public int read() throws IOException {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(Long.MAX_VALUE);
                                }
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            break;
                        }
                    }
                });
                System.setOut(new PrintStream(new OutputStream(pid){
                    private IOStreamFormatter byteProcessor;
                    {
                        this.byteProcessor = new IOStreamFormatter(n2);
                    }

                    public void write(int b2) throws IOException {
                        this.sendBytes(new byte[]{(byte)b2}, 0, 1);
                    }

                    public void write(byte[] b2) throws IOException {
                        this.sendBytes(b2, 0, b2.length);
                    }

                    public void write(byte[] b2, int off, int len) throws IOException {
                        this.sendBytes(b2, off, len);
                    }

                    private void sendBytes(byte[] bytes, int offset, int length) {
                        try {
                            new CMJ_systemOut().asyncExec(false, new Object[]{this.byteProcessor.process(bytes, offset, length)});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }));
                if (Utils.IS_WINDOWS) {
                    var10_15 = SWTNativeInterface.access$1();
                    synchronized (var10_15) {
                        messagingInterface_ = SWTNativeInterface.access$15();
                    }
                    new Thread("System.in unlocker"){

                        public void run() {
                            while (messagingInterface_.isAlive()) {
                                if (System.currentTimeMillis() - lastProcessTime > 100L) {
                                    new CMJ_unlockSystemIn().asyncExec(false, new Object[0]);
                                    lastProcessTime = System.currentTimeMillis();
                                }
                                try {
                                    8.sleep(100L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }.start();
                }
                ** GOTO lbl106
            }
            outInterface = new OutProcessSocketsMessagingInterface.SWTOutProcessSocketsMessagingInterface(socket, true, SWTNativeInterface.access$6(), pid);
            var7_17 = SWTNativeInterface.access$1();
            synchronized (var7_17) {
                SWTNativeInterface.access$2(outInterface);
                // MONITOREXIT @DISABLED, blocks:[7, 10] lbl95 : MonitorExitStatement: MONITOREXIT : var7_17
                if (true) ** GOTO lbl106
            }
            do {
                try {
                    SWTNativeInterface.access$17(System.currentTimeMillis());
                    if (!SWTNativeInterface.access$6().readAndDispatch()) {
                        SWTNativeInterface.access$17(0x7FFFFFFFFFFFFFFFL);
                        SWTNativeInterface.access$6().sleep();
                    }
                    SWTNativeInterface.access$17(0x7FFFFFFFFFFFFFFFL);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
lbl106:
                // 4 sources

            } while (SWTNativeInterface.access$6() != null && !SWTNativeInterface.access$6().isDisposed());
            if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTOPMESSAGE.get())) {
                System.err.println("Stopping peer VM #" + pid);
            }
        }

        static void runEventPump() {
            while (isEventPumpRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static class CMJ_handleClosedDisplay
        extends CommandMessage {
            private CMJ_handleClosedDisplay() {
            }

            public Object run(Object[] args) {
                SWTNativeInterface.handleQuit();
                return null;
            }
        }

        private static class CMJ_systemOut
        extends CommandMessage {
            private CMJ_systemOut() {
            }

            public Object run(Object[] args) {
                try {
                    System.out.write((byte[])args[0]);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return null;
            }
        }

        private static class CMJ_unlockSystemIn
        extends CommandMessage {
            private CMJ_unlockSystemIn() {
            }

            public Object run(Object[] args) throws Exception {
                new Message().asyncSend(true);
                return null;
            }
        }

        private static class CMN_destroyControls
        extends CommandMessage {
            private CMN_destroyControls() {
            }

            public Object run(Object[] args) throws Exception {
                if (display != null && !display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            SWTNativeInterface.destroyControls();
                        }
                    });
                }
                return null;
            }
        }

        private static class CMN_setProperties
        extends CommandMessage {
            private CMN_setProperties() {
            }

            public Object run(Object[] args) {
                Properties systemProperties = System.getProperties();
                Properties properties = (Properties)args[0];
                for (Object o2 : properties.keySet()) {
                    if (systemProperties.containsKey(o2)) continue;
                    try {
                        System.setProperty((String)o2, properties.getProperty((String)o2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        private static class IOStreamFormatter {
            private ByteArrayOutputStream baos = new ByteArrayOutputStream();
            private byte lastByte = (byte)Utils.LINE_SEPARATOR.charAt(Utils.LINE_SEPARATOR.length() - 1);
            private boolean isAddingMessage = true;
            private final byte[] prefixBytes;

            public IOStreamFormatter(int pid) {
                this.prefixBytes = ("NativeSwing[" + pid + "]: ").getBytes();
            }

            public byte[] process(byte[] bytes, int offset, int length) throws IOException {
                this.baos.reset();
                int i2 = offset;
                while (i2 < length) {
                    byte b2 = bytes[i2];
                    if (this.isAddingMessage) {
                        this.baos.write(this.prefixBytes);
                    }
                    this.isAddingMessage = b2 == this.lastByte;
                    this.baos.write(b2);
                    ++i2;
                }
                return this.baos.toByteArray();
            }
        }
    }
}

