/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.core.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Display;

abstract class OutProcessSocketsMessagingInterface
extends MessagingInterface {
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private Socket socket;
    private static final int OOS_RESET_THRESHOLD;
    private int oosByteCount;

    static {
        String maxByteCountProperty = NSSystemPropertySWT.INTERFACE_STREAMRESETTHRESHOLD.get();
        OOS_RESET_THRESHOLD = maxByteCountProperty != null ? Integer.parseInt(maxByteCountProperty) : 500000;
    }

    public OutProcessSocketsMessagingInterface(boolean isNativeSide, Socket socket, boolean exitOnEndOfStream, int pid) {
        super(isNativeSide, pid);
        this.socket = socket;
        this.initialize(exitOnEndOfStream);
    }

    public void destroy() {
        this.setAlive(false);
        try {
            this.ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void openChannel() {
        try {
            this.oos = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()){

                public synchronized void write(int b2) throws IOException {
                    super.write(b2);
                    OutProcessSocketsMessagingInterface outProcessSocketsMessagingInterface = OutProcessSocketsMessagingInterface.this;
                    outProcessSocketsMessagingInterface.oosByteCount = outProcessSocketsMessagingInterface.oosByteCount + 1;
                }

                public synchronized void write(byte[] b2, int off, int len) throws IOException {
                    super.write(b2, off, len);
                    OutProcessSocketsMessagingInterface outProcessSocketsMessagingInterface = OutProcessSocketsMessagingInterface.this;
                    outProcessSocketsMessagingInterface.oosByteCount = outProcessSocketsMessagingInterface.oosByteCount + len;
                }
            });
            this.oos.flush();
            this.ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void closeChannel() {
        try {
            this.oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageToChannel(Message message) throws IOException {
        ObjectOutputStream objectOutputStream = this.oos;
        synchronized (objectOutputStream) {
            this.oos.writeUnshared(message);
            this.oos.flush();
            if (this.oosByteCount > OOS_RESET_THRESHOLD) {
                this.oos.reset();
                this.oosByteCount = 0;
            }
        }
    }

    protected Message readMessageFromChannel() throws IOException, ClassNotFoundException {
        Object o2 = this.ois.readUnshared();
        if (o2 instanceof Message) {
            Message message = (Message)o2;
            if (IS_DEBUGGING_MESSAGES) {
                System.err.println("RECV: " + SWTNativeInterface.getMessageID(message) + ", " + message);
            }
            return message;
        }
        System.err.println("Unknown message: " + o2);
        return null;
    }

    static class SWTOutProcessSocketsMessagingInterface
    extends OutProcessSocketsMessagingInterface {
        private Display display;

        public SWTOutProcessSocketsMessagingInterface(Socket socket, boolean exitOnEndOfStream, Display display, int pid) {
            super(true, socket, exitOnEndOfStream, pid);
            this.display = display;
        }

        protected void asyncUIExec(Runnable runnable) {
            this.display.asyncExec(runnable);
        }

        public boolean isUIThread() {
            return Thread.currentThread() == this.display.getThread();
        }

        protected void terminate() {
            if (this.isNativeSide() && Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTSTOPMESSAGE.get())) {
                System.err.println("Stopping peer VM #" + this.getPID());
            }
            super.terminate();
        }
    }

    static class SwingOutProcessSocketsMessagingInterface
    extends OutProcessSocketsMessagingInterface {
        private final Process process;

        public SwingOutProcessSocketsMessagingInterface(Socket socket, boolean exitOnEndOfStream, Process process, int pid) {
            super(false, socket, exitOnEndOfStream, pid);
            this.process = process;
        }

        protected void asyncUIExec(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }

        public boolean isUIThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        public void destroy() {
            super.destroy();
            if (this.process != null && Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_OUTPROCESS_SYNCCLOSING.get())) {
                while (true) {
                    try {
                        this.process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

