/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class NativeModalDialogHandler {
    public void showModalDialog(Component component, final ControlCommandMessage message, final Object ... args) {
        Window window;
        Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        final JDialog dialog = Utils.IS_JAVA_6_OR_GREATER ? new JDialog(window, Dialog.ModalityType.APPLICATION_MODAL) : (window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)window, true));
        if (Utils.IS_MAC) {
            NativeModalComponent nativeModalComponent = new NativeModalComponent();
            dialog.getContentPane().add(nativeModalComponent.createEmbeddableComponent(new HashMap<Object, Object>()), "Center");
            nativeModalComponent.initializeNativePeer();
            this.processResult(message.syncExec(nativeModalComponent, args));
            dialog.dispose();
            return;
        }
        dialog.setUndecorated(true);
        dialog.setSize(0, 0);
        if (Utils.IS_WINDOWS) {
            Point location = component.getLocationOnScreen();
            location.x += component.getWidth() / 2 - 280;
            location.y += component.getHeight() / 2 - 200;
            dialog.setLocation(location);
        } else {
            dialog.setLocationRelativeTo(window);
        }
        MouseEvent mouseEvent = Utils.IS_JAVA_6_OR_GREATER ? new MouseEvent(window, 503, System.currentTimeMillis(), 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, false, 0) : new MouseEvent(window, 503, System.currentTimeMillis(), 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, false, 0);
        window.dispatchEvent(mouseEvent);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e2) {
                final NativeModalComponent nativeModalComponent = new NativeModalComponent();
                dialog.getContentPane().add(nativeModalComponent.createEmbeddableComponent(new HashMap<Object, Object>()), "Center");
                nativeModalComponent.initializeNativePeer();
                new Thread("Modal dialog handler"){

                    public void run() {
                        try {
                            final Object result = new CMN_openDialog().syncExec(nativeModalComponent, message, args);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    NativeModalDialogHandler.this.processResult(result);
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(dialog){
                                private final /* synthetic */ JDialog val$dialog;
                                {
                                    this.val$dialog = jDialog;
                                }

                                public void run() {
                                    this.val$dialog.dispose();
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }.start();
            }
        });
        dialog.setVisible(true);
    }

    protected abstract void processResult(Object var1);

    private static class CMN_openDialog
    extends ControlCommandMessage {
        private volatile transient Object result;

        private CMN_openDialog() {
        }

        public Object run(final Object[] args) throws Exception {
            Control control = this.getControl();
            if (control.isDisposed()) {
                return null;
            }
            Display display = control.getDisplay();
            if (display.getThread() != Thread.currentThread()) {
                try {
                    display.syncExec(new Runnable(){

                        public void run() {
                            try {
                                CMN_openDialog.this.result = CMN_openDialog.this.run(args);
                            }
                            catch (Throwable t2) {
                                throw new RuntimeException(t2);
                            }
                        }
                    });
                }
                catch (RuntimeException e2) {
                    throw (Exception)e2.getCause();
                }
                return this.result;
            }
            ControlCommandMessage commandMessage = (ControlCommandMessage)args[0];
            commandMessage.setControl(control);
            return commandMessage.run((Object[])args[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NativeModalComponent
    extends SWTNativeComponent {
        private NativeModalComponent() {
        }

        protected static Control createControl(Composite parent, Object[] parameters) {
            return new Composite(parent, 0);
        }

        @Override
        protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
            return super.createEmbeddableComponent(optionMap);
        }
    }
}

