/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.PeerVMProcessFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPeerVMProcessFactory
implements PeerVMProcessFactory {
    @Override
    public Process createProcess(String[] classpathItems, Map<String, String> systemPropertiesMap, String[] vmParams, String mainClass, String[] mainClassParameters) {
        String pathSeparator = SystemProperty.PATH_SEPARATOR.get();
        String[] candidateBinaries = new String[]{new File(SystemProperty.JAVA_HOME.get(), "bin/java").getAbsolutePath(), new File("/usr/lib/java").getAbsolutePath(), "java"};
        boolean isTryingAppletCompatibility = true;
        String[] stringArray = vmParams;
        int n2 = vmParams.length;
        int n3 = 0;
        while (n3 < n2) {
            String peerVMParam = stringArray[n3];
            if (peerVMParam.startsWith("-Xbootclasspath/a:")) {
                isTryingAppletCompatibility = false;
                break;
            }
            ++n3;
        }
        String javaVersion = SystemProperty.JAVA_VERSION.get();
        String vmParamsWithAppletCompatibility = null;
        if (isTryingAppletCompatibility && javaVersion != null && javaVersion.compareTo("1.6.0_10") >= 0 && "Sun Microsystems Inc.".equals(SystemProperty.JAVA_VENDOR.get())) {
            String javaHome = SystemProperty.JAVA_HOME.get();
            File[] deploymentFiles = new File[]{new File(javaHome, "lib/deploy.jar"), new File(javaHome, "lib/plugin.jar"), new File(javaHome, "lib/javaws.jar")};
            StringBuilder sbX = new StringBuilder();
            int i2 = 0;
            while (i2 < deploymentFiles.length) {
                File deploymentFile;
                if (i2 != 0) {
                    sbX.append(pathSeparator);
                }
                if ((deploymentFile = deploymentFiles[i2]).exists()) {
                    sbX.append(deploymentFile.getAbsolutePath());
                }
                ++i2;
            }
            vmParamsWithAppletCompatibility = sbX.indexOf(" ") != -1 ? "\"-Xbootclasspath/a:" + sbX + "\"" : "-Xbootclasspath/a:" + sbX;
        } else {
            isTryingAppletCompatibility = false;
        }
        int mode = isTryingAppletCompatibility ? 1 : 0;
        while (mode >= 0) {
            ArrayList<String> argList = new ArrayList<String>();
            String[] stringArray2 = candidateBinaries;
            if (candidateBinaries.length != 0) {
                String candidateBinary = stringArray2[0];
                argList.add(candidateBinary);
                if (mode == 1) {
                    argList.add(vmParamsWithAppletCompatibility);
                }
                String[] stringArray3 = vmParams;
                int n4 = vmParams.length;
                int n5 = 0;
                while (n5 < n4) {
                    String vmParam = stringArray3[n5];
                    argList.add(vmParam);
                    ++n5;
                }
                for (Map.Entry<String, String> propertyEntry : systemPropertiesMap.entrySet()) {
                    String value = propertyEntry.getValue();
                    if (Utils.IS_WINDOWS) {
                        value = value.replace("\\\"", "\"").replace("\"", "\\\"");
                    }
                    argList.add("-D" + propertyEntry.getKey() + "=" + value);
                }
                argList.add("-classpath");
                StringBuilder sb = new StringBuilder();
                int i3 = 0;
                while (i3 < classpathItems.length) {
                    if (i3 > 0) {
                        sb.append(pathSeparator);
                    }
                    sb.append(classpathItems[i3]);
                    ++i3;
                }
                argList.add(sb.toString());
                argList.add(mainClass);
                String[] stringArray4 = mainClassParameters;
                int n6 = mainClassParameters.length;
                n4 = 0;
                while (n4 < n6) {
                    String mainClassParameter = stringArray4[n4];
                    argList.add(mainClassParameter);
                    ++n4;
                }
                if (Boolean.parseBoolean(NSSystemPropertySWT.PEERVM_DEBUG_PRINTCOMMANDLINE.get())) {
                    System.err.println("Native Command: " + Arrays.toString(argList.toArray()));
                }
                try {
                    return new ProcessBuilder(argList).start();
                }
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            --mode;
        }
        return null;
    }
}

