/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.win32;

import chrriis.dj.nativeswing.swtimpl.components.win32.JWMediaPlayer;
import chrriis.dj.nativeswing.swtimpl.internal.IOleNativeComponent;

public class WMPSettings {
    private IOleNativeComponent nativeComponent;

    WMPSettings(JWMediaPlayer wMediaPlayer) {
        this.nativeComponent = (IOleNativeComponent)((Object)wMediaPlayer.getNativeComponent());
    }

    void setErrorDialogsEnabled(boolean isErrorDialogEnabled) {
        this.nativeComponent.setOleProperty(new String[]{"settings", "enableErrorDialogs"}, isErrorDialogEnabled);
    }

    public void setVolume(int volume) {
        if (volume < 0 || volume > 100) {
            throw new IllegalArgumentException("The volume must be between 0 and 100");
        }
        this.nativeComponent.setOleProperty(new String[]{"settings", "volume"}, volume);
    }

    public int getVolume() {
        try {
            return (Integer)this.nativeComponent.getOleProperty(new String[]{"settings", "volume"}, new Object[0]);
        }
        catch (IllegalStateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            return -1;
        }
    }

    public void setPlayCount(int playCount) {
        if (playCount <= 0) {
            throw new IllegalArgumentException("The play count must be strictly greater than 0");
        }
        this.nativeComponent.setOleProperty(new String[]{"settings", "playCount"}, playCount);
    }

    public int getPlayCount() {
        try {
            return (Integer)this.nativeComponent.getOleProperty(new String[]{"settings", "playCount"}, new Object[0]);
        }
        catch (IllegalStateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            return -1;
        }
    }

    public void setPlaySpeedFactor(float speedFactor) {
        if (speedFactor <= 0.0f) {
            throw new IllegalArgumentException("The rate must be strictly greater than 0!");
        }
        this.nativeComponent.setOleProperty(new String[]{"settings", "rate"}, (double)speedFactor);
    }

    public float getPlaySpeedFactor() {
        try {
            return ((Double)this.nativeComponent.getOleProperty(new String[]{"settings", "rate"}, new Object[0])).floatValue();
        }
        catch (IllegalStateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            return Float.NaN;
        }
    }

    public void setStereoBalance(int stereoBalance) {
        if (stereoBalance < 100 || stereoBalance > 100) {
            throw new IllegalArgumentException("The stereo balance must be between -100 and 100");
        }
        this.nativeComponent.setOleProperty(new String[]{"settings", "balance"}, stereoBalance);
    }

    public int getStereoBalance() {
        try {
            return (Integer)this.nativeComponent.getOleProperty(new String[]{"settings", "balance"}, new Object[0]);
        }
        catch (IllegalStateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            return -1;
        }
    }

    public void setAutoStart(boolean isAutoStart) {
        this.nativeComponent.setOleProperty(new String[]{"settings", "autoStart"}, isAutoStart);
    }

    public boolean isAutoStart() {
        return Boolean.TRUE.equals(this.nativeComponent.getOleProperty(new String[]{"settings", "autoStart"}, new Object[0]));
    }

    public void setMute(boolean isMute) {
        this.nativeComponent.setOleProperty(new String[]{"settings", "mute"}, isMute);
    }

    public boolean isMute() {
        return Boolean.TRUE.equals(this.nativeComponent.getOleProperty(new String[]{"settings", "mute"}, new Object[0]));
    }
}

