/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.components.Credentials;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAuthenticationHandler;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserFunction;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationParameters;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowFactory;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import chrriis.dj.nativeswing.swtimpl.components.core.NativeJSBrowserDetection;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeWebBrowser;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeWebBrowser
extends SWTNativeComponent
implements INativeWebBrowser {
    private INativeWebBrowser.WebBrowserRuntime runtime;
    private String xulRunnerHome;
    private Reference<JWebBrowser> webBrowser;
    private static Pattern JAVASCRIPT_LINE_COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);
    private static volatile Boolean isFixedJS;
    private String status;
    private String title;
    private int loadingProgress = 100;
    private Map<String, WebBrowserFunction> nameToFunctionMap;
    private WebBrowserAuthenticationHandler authenticationHandler;
    private Component embeddableComponent;

    @Override
    public INativeWebBrowser.WebBrowserRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    protected Object[] getNativePeerCreationParameters() {
        return new Object[]{this.runtime, this.xulRunnerHome};
    }

    protected static Control createControl(Composite parent, Object[] parameters) {
        String xulRunnerPath = (String)parameters[1];
        if (xulRunnerPath != null) {
            NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(xulRunnerPath);
        } else {
            xulRunnerPath = NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.get();
            if (xulRunnerPath == null && (xulRunnerPath = System.getenv("XULRUNNER_HOME")) != null) {
                NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(xulRunnerPath);
            }
        }
        int style = 0;
        INativeWebBrowser.WebBrowserRuntime wbRuntime = (INativeWebBrowser.WebBrowserRuntime)((Object)parameters[0]);
        switch (wbRuntime) {
            case XULRUNNER: {
                style |= 0x8000;
                break;
            }
            case WEBKIT: {
                style |= 0x10000;
            }
        }
        final Browser browser = new Browser(parent, style);
        NativeWebBrowser.configureBrowserFunction(browser);
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent e2) {
                new CMJ_closeWindow().asyncExec(browser, new Object[0]);
            }
        });
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent e2) {
                Browser newWebBrowser;
                boolean isDisposed;
                e2.required = true;
                final Integer componentID = (Integer)new CMJ_createWindow().syncExec(browser, new Object[0]);
                if (componentID == null) {
                    isDisposed = true;
                    Shell shell = new Shell();
                    newWebBrowser = new Browser(shell, browser.getStyle());
                    NativeWebBrowser.configureBrowserFunction(newWebBrowser);
                } else {
                    isDisposed = false;
                    newWebBrowser = (Browser)NativeWebBrowser.getControlRegistry().get(componentID);
                }
                e2.browser = newWebBrowser;
                newWebBrowser.addVisibilityWindowListener(new VisibilityWindowAdapter(){

                    public void show(WindowEvent e2) {
                        Browser browser = (Browser)e2.widget;
                        if (isDisposed) {
                            final Shell shell = browser.getShell();
                            e2.display.asyncExec(new Runnable(){

                                public void run() {
                                    shell.close();
                                }
                            });
                        } else {
                            browser.removeVisibilityWindowListener(this);
                            Point location = e2.location == null ? null : new Point(e2.location.x, e2.location.y);
                            Dimension size = e2.size == null || e2.size.x == 1 && e2.size.y == 1 ? null : new Dimension(e2.size.x, e2.size.y);
                            new CMJ_showWindow().asyncExec(newWebBrowser, componentID, e2.menuBar, e2.toolBar, e2.addressBar, e2.statusBar, location, size);
                        }
                    }
                });
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent e2) {
                browser.setData("Browser.loading", false);
                new CMJ_locationChanged().asyncExec(browser, e2.location, e2.top);
            }

            public void changing(LocationEvent e2) {
                String location = e2.location;
                if (location.startsWith("command://")) {
                    e2.doit = false;
                    String query = location.substring("command://".length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL(token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    String[] args = queryElementList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec(browser, command, args);
                    return;
                }
                if (location.startsWith("javascript:")) {
                    return;
                }
                browser.setData("CMJ_updateStatus.status", null);
                browser.setData("CMJ_updateProgress.progress", null);
                browser.setData("Browser.loading", true);
                e2.doit = Boolean.TRUE.equals(new CMJ_locationChanging().syncExec(browser, location, e2.top));
                if (!e2.doit) {
                    browser.setData("Browser.loading", false);
                    new CMJ_locationChangeCanceled().asyncExec(browser, location, e2.top);
                }
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent e2) {
                new CMJ_updateTitle().asyncExec(browser, e2.title);
            }
        });
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent e2) {
                final String oldStatus = (String)browser.getData("CMJ_updateStatus.status");
                final String newStatus = e2.text;
                if (newStatus.startsWith("scommand://")) {
                    e2.display.asyncExec(new Runnable(){

                        public void run() {
                            browser.execute(NativeWebBrowser.fixJavascript(browser, "if(decodeURIComponent('" + Utils.encodeURL(newStatus) + "') == window.status) {window.status = decodeURIComponent('" + Utils.encodeURL(oldStatus == null ? "" : oldStatus) + "');}"));
                        }
                    });
                    String query = newStatus.substring("scommand://".length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL(token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    String[] args = queryElementList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec(browser, command, args);
                    return;
                }
                if (!Utils.equals(oldStatus, newStatus)) {
                    browser.setData("CMJ_updateStatus.status", newStatus);
                    new CMJ_updateStatus().asyncExec(browser, newStatus);
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            private void updateProgress(int loadingProgress) {
                Integer oldLoadingProgress = (Integer)browser.getData("CMJ_updateProgress.progress");
                if (!Utils.equals(oldLoadingProgress, loadingProgress)) {
                    browser.setData("CMJ_updateProgress.progress", loadingProgress);
                    new CMJ_updateLoadingProgress().asyncExec(browser, loadingProgress);
                }
            }

            public void changed(ProgressEvent e2) {
                if (e2.total <= 0 || e2.total < e2.current) {
                    return;
                }
                browser.setData("Browser.loading", true);
                this.updateProgress(e2.current == e2.total ? 100 : Math.min(e2.current * 100 / e2.total, 99));
            }

            public void completed(ProgressEvent progressevent) {
                browser.setData("Browser.loading", false);
                this.updateProgress(100);
            }
        });
        NativeWebBrowser.registerDefaultPopupMenu(browser);
        return browser;
    }

    private static void configureBrowserFunction(Browser browser) {
        new NSCommandBrowserFunction(browser);
        new NSConsolePrintingBrowserFunction(browser, false);
        new NSConsolePrintingBrowserFunction(browser, true);
    }

    public NativeWebBrowser(JWebBrowser webBrowser, INativeWebBrowser.WebBrowserRuntime runtime) {
        this.webBrowser = new WeakReference<JWebBrowser>(webBrowser);
        if (runtime == INativeWebBrowser.WebBrowserRuntime.DEFAULT) {
            String runtimeProperty = NSSystemPropertySWT.WEBBROWSER_RUNTIME.get();
            if ("xulrunner".equals(runtimeProperty)) {
                runtime = INativeWebBrowser.WebBrowserRuntime.XULRUNNER;
            } else if ("webkit".equals(runtimeProperty)) {
                runtime = INativeWebBrowser.WebBrowserRuntime.WEBKIT;
            }
        }
        this.runtime = runtime;
        if (runtime == INativeWebBrowser.WebBrowserRuntime.XULRUNNER) {
            this.xulRunnerHome = NSSystemPropertySWT.WEBBROWSER_XULRUNNER_HOME.get();
        }
    }

    public static void clearSessionCookies() {
        new CMN_clearSessionCookies().asyncExec(true, new Object[0]);
    }

    public static String getCookie(String url, String name) {
        return (String)new CMN_getCookie().syncExec(true, url, name);
    }

    public static void setCookie(String url, String value) {
        new CMN_setCookie().asyncExec(true, url, value);
    }

    @Override
    public String getResourceLocation() {
        return (String)this.runSync(new CMN_getResourceLocation(), new Object[0]);
    }

    @Override
    public boolean navigate(String resourceLocation, WebBrowserNavigationParameters parameters) {
        return Boolean.TRUE.equals(this.runSync(new CMN_navigate(), resourceLocation, parameters == null ? null : parameters.getPostData(), parameters == null ? null : parameters.getHeaders()));
    }

    @Override
    public String getHTMLContent() {
        return (String)this.runSync(new CMN_getHTMLContent(), new Object[0]);
    }

    @Override
    public boolean setHTMLContent(String html) {
        return Boolean.TRUE.equals(this.runSync(new CMN_setHTMLContent(), html));
    }

    @Override
    public boolean isJavascriptEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isJavascriptEnabled(), new Object[0]));
    }

    @Override
    public void setJavascriptEnabled(boolean isJavascriptEnabled) {
        this.runAsync(new CMN_setJavascriptEnabled(), isJavascriptEnabled);
    }

    private static String fixJavascript(Browser browser, String script) {
        if ("mozilla".equals(browser.getBrowserType())) {
            if (isFixedJS == null) {
                isFixedJS = "%25".equals(browser.evaluate("return '%25'"));
            }
            if (!isFixedJS.booleanValue()) {
                script = JAVASCRIPT_LINE_COMMENT_PATTERN.matcher(script).replaceAll("");
                script = Utils.encodeURL(script);
            }
        }
        return script;
    }

    @Override
    public boolean executeJavascriptAndWait(String script) {
        return Boolean.TRUE.equals(this.runSync(new CMN_executeJavascript(), script));
    }

    @Override
    public void executeJavascript(String script) {
        this.runAsync(new CMN_executeJavascript(), script);
    }

    @Override
    public Object executeJavascriptWithResult(String script) {
        return this.runSync(new CMN_executeJavascriptWithResult(), script);
    }

    @Override
    public void stopLoading() {
        this.runAsync(new CMN_stopLoading(), new Object[0]);
    }

    @Override
    public void reloadPage() {
        this.runAsync(new CMN_reloadPage(), new Object[0]);
    }

    @Override
    public boolean isBackNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isBackNavigationEnabled(), new Object[0]));
    }

    @Override
    public void navigateBack() {
        this.runAsync(new CMN_navigateBack(), new Object[0]);
    }

    @Override
    public boolean isForwardNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isForwardNavigationEnabled(), new Object[0]));
    }

    @Override
    public void navigateForward() {
        this.runAsync(new CMN_navigateForward(), new Object[0]);
    }

    private static void registerDefaultPopupMenu(final Browser browser) {
        Menu oldMenu = browser.getMenu();
        if (oldMenu != null) {
            oldMenu.dispose();
        }
        if (!"mozilla".equals(browser.getBrowserType())) {
            browser.setMenu(null);
            return;
        }
        Menu menu = new Menu(browser.getShell(), 8);
        String className = JWebBrowser.class.getName();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/WebBrowser");
        final MenuItem backMenuItem = new MenuItem(menu, 8);
        backMenuItem.setText(bundle.getString("SystemMenuBack"));
        backMenuItem.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuBackIcon"))));
        backMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                browser.back();
            }
        });
        final MenuItem forwardMenuItem = new MenuItem(menu, 8);
        forwardMenuItem.setText(bundle.getString("SystemMenuForward"));
        forwardMenuItem.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuForwardIcon"))));
        forwardMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                browser.forward();
            }
        });
        MenuItem reloadMenuItem = new MenuItem(menu, 8);
        reloadMenuItem.setText(bundle.getString("SystemMenuReload"));
        reloadMenuItem.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuReloadIcon"))));
        reloadMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                browser.refresh();
            }
        });
        final MenuItem stopMenuItem = new MenuItem(menu, 8);
        stopMenuItem.setText(bundle.getString("SystemMenuStop"));
        stopMenuItem.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuStopIcon"))));
        stopMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                browser.stop();
            }
        });
        menu.addMenuListener(new MenuAdapter(){

            public void menuShown(MenuEvent e2) {
                backMenuItem.setEnabled(browser.isBackEnabled());
                forwardMenuItem.setEnabled(browser.isForwardEnabled());
                stopMenuItem.setEnabled(Boolean.TRUE.equals(browser.getData("Browser.loading")));
            }
        });
        browser.setMenu(menu);
    }

    @Override
    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.runAsync(new CMN_setDefaultPopupMenuRegistered(), isDefaultPopupMenuRegistered);
    }

    @Override
    public String getStatusText() {
        return this.status == null ? "" : this.status;
    }

    @Override
    public String getPageTitle() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public int getLoadingProgress() {
        return this.loadingProgress;
    }

    @Override
    public void registerFunction(WebBrowserFunction function) {
        String functionName = function.getName();
        if (this.nameToFunctionMap == null) {
            this.nameToFunctionMap = new HashMap<String, WebBrowserFunction>();
        } else {
            WebBrowserFunction oldFunction = this.nameToFunctionMap.get(functionName);
            if (oldFunction == function) {
                return;
            }
            if (oldFunction != null) {
                this.unregisterFunction(oldFunction);
            }
        }
        this.nameToFunctionMap.put(functionName, function);
        this.runAsync(new CMN_registerFunction(), functionName);
    }

    @Override
    public void unregisterFunction(WebBrowserFunction function) {
        if (this.nameToFunctionMap == null) {
            return;
        }
        String functionName = function.getName();
        WebBrowserFunction currentFunction = this.nameToFunctionMap.get(functionName);
        if (currentFunction != function) {
            return;
        }
        this.nameToFunctionMap.remove(function);
        if (this.nameToFunctionMap.isEmpty()) {
            this.nameToFunctionMap = null;
        }
        this.runAsync(new CMN_unregisterFunction(), functionName);
    }

    @Override
    public void setAuthenticationHandler(WebBrowserAuthenticationHandler authenticationHandler) {
        if (this.authenticationHandler == authenticationHandler) {
            return;
        }
        boolean isActivated = this.authenticationHandler == null;
        boolean isDeactivated = authenticationHandler == null;
        this.authenticationHandler = authenticationHandler;
        if (isActivated || isDeactivated) {
            this.runAsync(new CMN_setAuthenticationHandler(), isActivated);
        }
    }

    @Override
    public WebBrowserAuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public String getBrowserType() {
        return (String)this.runSync(new CMN_getBrowserType(), new Object[0]);
    }

    @Override
    public String getBrowserVersion() {
        return (String)this.runSync(new CMN_getBrowserVersion(), new Object[0]);
    }

    @Override
    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(WebBrowserListener.class, listener);
    }

    @Override
    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(WebBrowserListener.class, listener);
    }

    @Override
    public Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        this.embeddableComponent = super.createEmbeddableComponent(optionMap);
        return this.embeddableComponent;
    }

    @Override
    protected void disposeNativePeer() {
        super.disposeNativePeer();
    }

    @Override
    public boolean unloadAndDispose() {
        if (this.isNativePeerInitialized() && Boolean.TRUE.equals(this.runSync(new CMN_unloadAndDispose(), new Object[0]))) {
            return false;
        }
        this.disposeNativePeer();
        return true;
    }

    @Override
    public boolean print(boolean isShowingDialog) {
        return Boolean.TRUE.equals(this.runSync(new CMN_print(), isShowingDialog));
    }

    private static class CMJ_closeWindow
    extends ControlCommandMessage {
        private CMJ_closeWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).windowClosing(e2);
                }
                i2 -= 2;
            }
            JWebBrowserWindow browserWindow = webBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                browserWindow.dispose();
            }
            webBrowser.disposeNativePeer();
            return null;
        }
    }

    private static class CMJ_commandReceived
    extends ControlCommandMessage {
        private CMJ_commandReceived() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserCommandEvent e2 = null;
            String command = (String)args[0];
            Object[] arguments = (Object[])args[1];
            boolean isInternal = command.startsWith("[Chrriis]");
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserCommandEvent(webBrowser, command, arguments);
                    }
                    WebBrowserListener webBrowserListener = (WebBrowserListener)listeners[i2 + 1];
                    if (!isInternal || webBrowserListener.getClass().getName().startsWith("chrriis.")) {
                        webBrowserListener.commandReceived(e2);
                    }
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMJ_consolePrinting
    extends ControlCommandMessage {
        private CMJ_consolePrinting() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            System.out.println(args[0]);
            return null;
        }
    }

    private static class CMJ_createWindow
    extends ControlCommandMessage {
        private CMJ_createWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser jWebBrowser;
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            switch (nativeWebBrowser.getRuntime()) {
                case WEBKIT: {
                    jWebBrowser = new JWebBrowser(JWebBrowser.useWebkitRuntime());
                    break;
                }
                case XULRUNNER: {
                    jWebBrowser = new JWebBrowser(JWebBrowser.useXULRunnerRuntime());
                    break;
                }
                default: {
                    jWebBrowser = new JWebBrowser(new NSOption[0]);
                }
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowWillOpenEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0 && jWebBrowser != null) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserWindowWillOpenEvent(webBrowser, jWebBrowser);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).windowWillOpen(e2);
                    jWebBrowser = e2.isConsumed() ? null : e2.getNewWebBrowser();
                }
                i2 -= 2;
            }
            if (jWebBrowser == null) {
                return null;
            }
            if (!jWebBrowser.isNativePeerInitialized()) {
                Window windowAncestor = SwingUtilities.getWindowAncestor(jWebBrowser);
                if (windowAncestor == null) {
                    Window parentWindow = e2.isDialogWindow() ? SwingUtilities.getWindowAncestor(webBrowser) : null;
                    windowAncestor = (Window)((Object)WebBrowserWindowFactory.create(parentWindow, jWebBrowser));
                }
                jWebBrowser.getNativeComponent().initializeNativePeer();
            }
            return ((NativeWebBrowser)jWebBrowser.getNativeComponent()).getComponentID();
        }
    }

    private static class CMJ_getCredentials
    extends ControlCommandMessage {
        private CMJ_getCredentials() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            WebBrowserAuthenticationHandler authenticationHandler = nativeWebBrowser.getAuthenticationHandler();
            if (authenticationHandler == null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = true;
                return objectArray;
            }
            String resourceLocation = (String)args[0];
            Credentials credentials = authenticationHandler.getCredentials(webBrowser, resourceLocation);
            if (credentials == null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = false;
                return objectArray;
            }
            return new Object[]{true, credentials.getUserName(), credentials.getPassword()};
        }
    }

    private static class CMJ_invokeFunction
    extends ControlCommandMessage {
        private CMJ_invokeFunction() {
        }

        public Object run(Object[] args) {
            WebBrowserFunction function;
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            if (nativeWebBrowser.nameToFunctionMap != null && (function = (WebBrowserFunction)nativeWebBrowser.nameToFunctionMap.get(args[0])) != null) {
                return function.invoke(webBrowser, (Object[])args[1]);
            }
            return null;
        }
    }

    private static class CMJ_locationChangeCanceled
    extends ControlCommandMessage {
        private CMJ_locationChangeCanceled() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).locationChangeCanceled(e2);
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanged
    extends ControlCommandMessage {
        private CMJ_locationChanged() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).locationChanged(e2);
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanging
    extends ControlCommandMessage {
        private CMJ_locationChanging() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return false;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            boolean isNavigating = true;
            WebBrowserNavigationEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).locationChanging(e2);
                    isNavigating &= !e2.isConsumed();
                }
                i2 -= 2;
            }
            return isNavigating;
        }
    }

    private static class CMJ_showWindow
    extends ControlCommandMessage {
        private CMJ_showWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            int componentID = (Integer)args[0];
            final JWebBrowser newWebBrowser = (JWebBrowser)((NativeWebBrowser)NativeWebBrowser.getNativeComponentRegistry().get(componentID)).webBrowser.get();
            newWebBrowser.setMenuBarVisible((Boolean)args[1]);
            newWebBrowser.setButtonBarVisible((Boolean)args[2]);
            newWebBrowser.setLocationBarVisible((Boolean)args[3]);
            newWebBrowser.setStatusBarVisible((Boolean)args[4]);
            Point location = (Point)args[5];
            Dimension size = (Dimension)args[6];
            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                if (size != null) {
                    ((Window)((Object)browserWindow)).validate();
                    Dimension windowSize = browserWindow.getSize();
                    Dimension webBrowserSize = ((NativeWebBrowser)browserWindow.getWebBrowser().getNativeComponent()).embeddableComponent.getSize();
                    if (size.width > 0) {
                        windowSize.width -= webBrowserSize.width;
                        windowSize.width += size.width;
                    }
                    if (size.height > 0) {
                        windowSize.height -= webBrowserSize.height;
                        windowSize.height += size.height;
                    }
                    browserWindow.setSize(windowSize);
                }
                if (location != null) {
                    browserWindow.setLocation(location);
                }
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowOpeningEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0 && newWebBrowser != null) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserWindowOpeningEvent(webBrowser, newWebBrowser, location, size);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).windowOpening(e2);
                }
                i2 -= 2;
            }
            new Thread(){

                public void run() {
                    try {
                        1.sleep(600L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
                            if (browserWindow != null && !newWebBrowser.getNativeComponent().isNativePeerDisposed()) {
                                browserWindow.setVisible(true);
                            }
                        }
                    });
                }
            }.start();
            return null;
        }
    }

    private static class CMJ_updateLoadingProgress
    extends ControlCommandMessage {
        private CMJ_updateLoadingProgress() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.loadingProgress = (Integer)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).loadingProgressChanged(e2);
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateStatus
    extends ControlCommandMessage {
        private CMJ_updateStatus() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.status = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).statusChanged(e2);
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateTitle
    extends ControlCommandMessage {
        private CMJ_updateTitle() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.title = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e2 = null;
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == WebBrowserListener.class) {
                    if (e2 == null) {
                        e2 = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i2 + 1]).titleChanged(e2);
                }
                i2 -= 2;
            }
            return null;
        }
    }

    private static class CMN_clearSessionCookies
    extends CommandMessage {
        private CMN_clearSessionCookies() {
        }

        public Object run(Object[] args) {
            Browser.clearSessions();
            return null;
        }
    }

    private static class CMN_executeJavascript
    extends ControlCommandMessage {
        private CMN_executeJavascript() {
        }

        public Object run(Object[] args) {
            String script = (String)args[0];
            Browser browser = (Browser)this.getControl();
            return browser.execute(NativeWebBrowser.fixJavascript(browser, script));
        }
    }

    private static class CMN_executeJavascriptWithResult
    extends ControlCommandMessage {
        private CMN_executeJavascriptWithResult() {
        }

        public Object run(Object[] args) {
            String script = (String)args[0];
            Browser browser = (Browser)this.getControl();
            return browser.evaluate(NativeWebBrowser.fixJavascript(browser, script));
        }
    }

    private static class CMN_getBrowserType
    extends ControlCommandMessage {
        private CMN_getBrowserType() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getBrowserType();
        }
    }

    private static class CMN_getBrowserVersion
    extends ControlCommandMessage {
        private CMN_getBrowserVersion() {
        }

        public Object run(Object[] args) {
            return new NativeJSBrowserDetection((Browser)((Browser)this.getControl())).browserVersion;
        }
    }

    private static class CMN_getCookie
    extends CommandMessage {
        private CMN_getCookie() {
        }

        public Object run(Object[] args) {
            return Browser.getCookie((String)args[1], (String)args[0]);
        }
    }

    private static class CMN_getHTMLContent
    extends ControlCommandMessage {
        private CMN_getHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getText();
        }
    }

    private static class CMN_getResourceLocation
    extends ControlCommandMessage {
        private CMN_getResourceLocation() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getUrl();
        }
    }

    private static class CMN_isBackNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isBackNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isBackEnabled();
        }
    }

    private static class CMN_isForwardNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isForwardNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isForwardEnabled();
        }
    }

    private static class CMN_isJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_isJavascriptEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getJavascriptEnabled();
        }
    }

    private static class CMN_navigate
    extends ControlCommandMessage {
        private CMN_navigate() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setUrl((String)args[0], (String)args[1], (String[])args[2]);
        }
    }

    private static class CMN_navigateBack
    extends ControlCommandMessage {
        private CMN_navigateBack() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).back();
        }
    }

    private static class CMN_navigateForward
    extends ControlCommandMessage {
        private CMN_navigateForward() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).forward();
        }
    }

    private static class CMN_print
    extends ControlCommandMessage {
        private CMN_print() {
        }

        public Object run(Object[] args) {
            boolean isShowingDialog = (Boolean)args[0];
            Browser browser = (Browser)this.getControl();
            if (Utils.IS_WINDOWS && "ie".equals(browser.getBrowserType())) {
                try {
                    Class<?> ieClass = Class.forName("org.eclipse.swt.browser.IE");
                    Field webBrowserField = Browser.class.getDeclaredField("webBrowser");
                    webBrowserField.setAccessible(true);
                    Object swtWebBrowser = webBrowserField.get(browser);
                    if (ieClass.isInstance(swtWebBrowser)) {
                        Field autoField = ieClass.getDeclaredField("auto");
                        autoField.setAccessible(true);
                        OleAutomation swtBrowserAutomation = (OleAutomation)autoField.get(swtWebBrowser);
                        int[] rgdispid = swtBrowserAutomation.getIDsOfNames(new String[]{"ExecWB", "cmdID", "cmdexecopt"});
                        Variant[] rgvarg = new Variant[]{new Variant(6), new Variant(isShowingDialog ? 1 : 2)};
                        int[] rgdispidNamedArgs = new int[]{rgdispid[1], rgdispid[2]};
                        swtBrowserAutomation.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!isShowingDialog) {
                return false;
            }
            return browser.execute("print();");
        }
    }

    private static class CMN_registerFunction
    extends ControlCommandMessage {
        private CMN_registerFunction() {
        }

        public Object run(Object[] args) {
            Browser browser = (Browser)this.getControl();
            String functionName = (String)args[0];
            BrowserFunction browserFunction = new BrowserFunction(browser, functionName){

                public Object function(Object[] arguments) {
                    return new CMJ_invokeFunction().syncExec(this.getBrowser(), this.getName(), arguments);
                }
            };
            browser.setData("nsFunction_" + functionName, browserFunction);
            return null;
        }
    }

    private static class CMN_reloadPage
    extends ControlCommandMessage {
        private CMN_reloadPage() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).refresh();
            return null;
        }
    }

    private static class CMN_setAuthenticationHandler
    extends ControlCommandMessage {
        private CMN_setAuthenticationHandler() {
        }

        public Object run(Object[] args) {
            final Browser browser = (Browser)this.getControl();
            boolean isActive = (Boolean)args[0];
            if (isActive) {
                AuthenticationListener authenticationListener = new AuthenticationListener(){

                    public void authenticate(AuthenticationEvent e2) {
                        Object[] result = (Object[])new CMJ_getCredentials().syncExec(browser, e2.location);
                        boolean doIt = (Boolean)result[0];
                        if (doIt) {
                            e2.user = (String)result[1];
                            e2.password = (String)result[2];
                        } else {
                            e2.doit = false;
                        }
                    }
                };
                browser.setData("Browser.authenticationListener", authenticationListener);
                browser.addAuthenticationListener(authenticationListener);
            } else {
                browser.removeAuthenticationListener((AuthenticationListener)browser.getData("Browser.authenticationListener"));
                browser.setData("Browser.authenticationListener", null);
            }
            return null;
        }
    }

    private static class CMN_setCookie
    extends CommandMessage {
        private CMN_setCookie() {
        }

        public Object run(Object[] args) {
            Browser.setCookie((String)args[1], (String)args[0]);
            return null;
        }
    }

    private static class CMN_setDefaultPopupMenuRegistered
    extends ControlCommandMessage {
        private CMN_setDefaultPopupMenuRegistered() {
        }

        public Object run(Object[] args) {
            Browser browser = (Browser)this.getControl();
            boolean isDefaultPopupMenuRegistered = (Boolean)args[0];
            if (isDefaultPopupMenuRegistered) {
                NativeWebBrowser.registerDefaultPopupMenu(browser);
            } else {
                Menu oldMenu = browser.getMenu();
                if (oldMenu != null) {
                    oldMenu.dispose();
                }
                final Menu menu = new Menu(browser.getShell(), 8);
                menu.addMenuListener(new MenuAdapter(){

                    public void menuShown(MenuEvent e2) {
                        menu.setVisible(false);
                    }
                });
                browser.setMenu(menu);
            }
            return null;
        }
    }

    private static class CMN_setHTMLContent
    extends ControlCommandMessage {
        private CMN_setHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setText((String)args[0]);
        }
    }

    private static class CMN_setJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_setJavascriptEnabled() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).setJavascriptEnabled((Boolean)args[0]);
            return null;
        }
    }

    private static class CMN_stopLoading
    extends ControlCommandMessage {
        private CMN_stopLoading() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).stop();
            return null;
        }
    }

    private static class CMN_unloadAndDispose
    extends ControlCommandMessage {
        private CMN_unloadAndDispose() {
        }

        public Object run(Object[] args) {
            boolean isAlive = true;
            Browser browser = (Browser)this.getControl();
            if (browser != null && !browser.isDisposed()) {
                Shell shell = browser.getShell();
                if (browser.close()) {
                    isAlive = false;
                    if (shell != null) {
                        shell.dispose();
                    }
                }
            }
            return isAlive;
        }
    }

    private static class CMN_unregisterFunction
    extends ControlCommandMessage {
        private CMN_unregisterFunction() {
        }

        public Object run(Object[] args) {
            Browser browser = (Browser)this.getControl();
            String key = "nsFunction_" + (String)args[0];
            BrowserFunction browserFunction = (BrowserFunction)browser.getData(key);
            browser.setData(key, null);
            browserFunction.dispose();
            return null;
        }
    }

    private static class NSCommandBrowserFunction
    extends BrowserFunction {
        public NSCommandBrowserFunction(Browser browser) {
            super(browser, "sendNSCommand");
        }

        public Object function(Object[] args) {
            Object[] commandArgs;
            String command;
            String string = args.length >= 1 ? (args[0] instanceof String ? (String)args[0] : "") : (command = "");
            if (args.length > 1) {
                commandArgs = new Object[args.length - 1];
                System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
                args = commandArgs;
            } else {
                commandArgs = new Object[]{};
            }
            new CMJ_commandReceived().asyncExec(this.getBrowser(), command, commandArgs);
            return null;
        }
    }

    private static class NSConsolePrintingBrowserFunction
    extends BrowserFunction {
        public NSConsolePrintingBrowserFunction(Browser browser, boolean isErr) {
            super(browser, isErr ? "nsConsoleErr" : "nsConsoleOut");
        }

        public Object function(Object[] args) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < args.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(args[i2]);
                ++i2;
            }
            new CMJ_consolePrinting().asyncExec(this.getBrowser(), sb.toString());
            return null;
        }
    }
}

