/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.MozillaXPCOM;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeMozillaXPCOM;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Shell;
import org.mozilla.xpcom.Mozilla;

class NativeMozillaXPCOM
implements INativeMozillaXPCOM {
    private static Map<Integer, Object> idToNativeInterfaceMap = new HashMap<Integer, Object>();
    private static Map<Integer, WeakReference<NativeSwingProxy>> idToProxyInterfaceReferenceMap = new HashMap<Integer, WeakReference<NativeSwingProxy>>();
    private static Map<InterfaceInfo, Integer> interfaceInfoToIDMap = new HashMap<InterfaceInfo, Integer>();
    private static int nextNativeSideID = 1;
    private static int nextSwingSideID = -1;

    NativeMozillaXPCOM() {
    }

    public Object getWebBrowser(JWebBrowser webBrowser) {
        return this.unpack(webBrowser.getNativeComponent().runSync(new CMN_getWebBrowser(), new Object[0]));
    }

    public boolean initialize() {
        String path = NSSystemPropertySWT.WEBBROWSER_XULRUNNER_HOME.get();
        if (path == null) {
            path = NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.get();
        } else {
            NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(path);
        }
        if (Utils.IS_MAC) {
            if (path == null) {
                path = System.getenv("XULRUNNER_HOME");
            }
            if (path == null) {
                return false;
            }
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            Mozilla.getInstance().initialize(file);
        } else {
            Shell shell = new Shell(0);
            new Browser(shell, 32768);
            shell.dispose();
        }
        return true;
    }

    public Object pack(Object o2, boolean isNativeSide) {
        return NativeMozillaXPCOM.pack_(o2, isNativeSide);
    }

    static Object pack_(Object o2, boolean isNativeSide) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Object[]) {
            Object[] array = (Object[])o2;
            Object[] newArray = new Object[array.length];
            int i2 = 0;
            while (i2 < array.length) {
                newArray[i2] = NativeMozillaXPCOM.pack_(array[i2], isNativeSide);
                ++i2;
            }
            return new ArrayInfo(array.getClass(), newArray);
        }
        Package pckage = o2.getClass().getPackage();
        if (pckage != null && pckage.getName().equals("java.lang")) {
            return o2;
        }
        InterfaceInfo interfaceInfo = new InterfaceInfo(o2);
        Integer id2 = interfaceInfoToIDMap.get(interfaceInfo);
        if (id2 == null) {
            ArrayList interfaceList = new ArrayList();
            ClassLoader cl = MozillaXPCOM.class.getClassLoader();
            Class<?>[] classArray = o2.getClass().getInterfaces();
            int n2 = classArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Class<?> intrface = classArray[n3];
                Class<?> interfaceClass = null;
                try {
                    interfaceClass = Class.forName(intrface.getName(), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (interfaceClass == intrface) {
                    interfaceList.add(intrface);
                }
                ++n3;
            }
            interfaceList.add(NativeSwingProxy.class);
            id2 = isNativeSide ? Integer.valueOf(nextNativeSideID++) : Integer.valueOf(nextSwingSideID--);
            idToNativeInterfaceMap.put(id2, o2);
            interfaceInfoToIDMap.put(interfaceInfo, id2);
            return new InterfaceDefinition(id2, interfaceList.toArray(new Class[0]), true, !isNativeSide);
        }
        return new InterfaceDefinition(id2, null, !(o2 instanceof NativeSwingProxy), !isNativeSide);
    }

    public Object unpack(Object o2) {
        return NativeMozillaXPCOM.unpack_(o2);
    }

    static Object unpack_(Object o2) {
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof ArrayInfo) {
            ArrayInfo arrayInfo = (ArrayInfo)o2;
            Class<?> arrayClass = arrayInfo.getArrayClass();
            Object[] items = arrayInfo.getItems();
            Object[] array = (Object[])Array.newInstance(arrayClass.getComponentType(), items.length);
            int i2 = 0;
            while (i2 < items.length) {
                array[i2] = NativeMozillaXPCOM.unpack_(items[i2]);
                ++i2;
            }
            return array;
        }
        if (o2 instanceof InterfaceDefinition) {
            InterfaceDefinition interfaceDefinition = (InterfaceDefinition)o2;
            final Integer id2 = interfaceDefinition.getID();
            if (interfaceDefinition.isProxy()) {
                NativeSwingProxy proxyInterface;
                WeakReference<NativeSwingProxy> proxyInterfaceReference = idToProxyInterfaceReferenceMap.get(id2);
                NativeSwingProxy nativeSwingProxy = proxyInterface = proxyInterfaceReference == null ? null : (NativeSwingProxy)proxyInterfaceReference.get();
                if (proxyInterface == null) {
                    Class<?>[] interfaces = interfaceDefinition.getInterfaces();
                    final boolean isNativeSide = interfaceDefinition.isNativeSide();
                    proxyInterface = (NativeSwingProxy)Proxy.newProxyInstance(MozillaXPCOM.class.getClassLoader(), interfaces, new InvocationHandler(){

                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            String methodName = method.getName();
                            Class<?>[] parameterTypes = method.getParameterTypes();
                            if ("finalize".equals(methodName) && parameterTypes.length == 0) {
                                idToProxyInterfaceReferenceMap.remove(id2);
                                interfaceInfoToIDMap.remove(new InterfaceInfo(this));
                                new CM_disposeResources().syncExec(!isNativeSide, id2);
                                return null;
                            }
                            RunMethodResult result = (RunMethodResult)new CM_runMethod().syncExec(!isNativeSide, id2, methodName, parameterTypes, NativeMozillaXPCOM.pack_(args, isNativeSide), !isNativeSide);
                            Object[] outParams = result.getOutParams();
                            if (outParams != null) {
                                int cur = 0;
                                Object[] objectArray = args;
                                int n2 = args.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    Object o2 = objectArray[n3];
                                    if (o2 instanceof Object[]) {
                                        Object[] in = (Object[])o2;
                                        Object[] out = (Object[])NativeMozillaXPCOM.unpack_(outParams[cur++]);
                                        int j2 = 0;
                                        while (j2 < in.length) {
                                            in[j2] = out[j2];
                                            ++j2;
                                        }
                                    }
                                    ++n3;
                                }
                            }
                            return NativeMozillaXPCOM.unpack_(result.getResult());
                        }
                    });
                    idToProxyInterfaceReferenceMap.put(id2, new WeakReference<NativeSwingProxy>(proxyInterface));
                    interfaceInfoToIDMap.put(new InterfaceInfo(proxyInterface), id2);
                }
                return proxyInterface;
            }
            return idToNativeInterfaceMap.get(id2);
        }
        return o2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayInfo
    implements Serializable {
        private Class<?> arrayClass;
        private Object[] content;

        public ArrayInfo(Class<?> arrayClass, Object[] content) {
            ClassLoader cl = MozillaXPCOM.class.getClassLoader();
            Class<?> arrayClass_ = null;
            while (true) {
                try {
                    arrayClass_ = Class.forName(arrayClass.getName(), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (arrayClass_ == arrayClass) break;
                arrayClass_ = arrayClass_.getSuperclass();
            }
            this.arrayClass = arrayClass;
            this.content = content;
        }

        public Class<?> getArrayClass() {
            return this.arrayClass;
        }

        public Object[] getItems() {
            return this.content;
        }

        public String toString() {
            return Arrays.deepToString(this.content);
        }
    }

    private static class CMN_getWebBrowser
    extends ControlCommandMessage {
        private CMN_getWebBrowser() {
        }

        public Object run(Object[] args) {
            return NativeMozillaXPCOM.pack_(((Browser)this.getControl()).getWebBrowser(), true);
        }
    }

    private static class CM_disposeResources
    extends CommandMessage {
        private CM_disposeResources() {
        }

        public Object run(Object[] args) {
            Object nativeInterface = idToNativeInterfaceMap.remove(args[0]);
            interfaceInfoToIDMap.remove(new InterfaceInfo(nativeInterface));
            return null;
        }
    }

    private static class CM_runMethod
    extends CommandMessage {
        private CM_runMethod() {
        }

        public Object run(Object[] args) {
            Integer interfaceID = (Integer)args[0];
            String methodName = (String)args[1];
            Class[] parameterTypes = (Class[])args[2];
            Object[] parameterValues = (Object[])NativeMozillaXPCOM.unpack_(args[3]);
            boolean isNativeSide = (Boolean)args[4];
            Object nativeInterface = idToNativeInterfaceMap.get(interfaceID);
            try {
                Method method = nativeInterface.getClass().getMethod(methodName, parameterTypes);
                method.setAccessible(true);
                Object result = method.invoke(nativeInterface, parameterValues);
                ArrayList<Object> outParamList = null;
                if (parameterValues != null) {
                    outParamList = new ArrayList<Object>();
                    Object[] objectArray = parameterValues;
                    int n2 = parameterValues.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Object o2 = objectArray[n3];
                        if (o2 instanceof Object[]) {
                            outParamList.add(NativeMozillaXPCOM.pack_(o2, isNativeSide));
                        }
                        ++n3;
                    }
                }
                return new RunMethodResult(NativeMozillaXPCOM.pack_(result, isNativeSide), outParamList == null || outParamList.isEmpty() ? null : outParamList.toArray());
            }
            catch (Exception e2) {
                throw new IllegalStateException("The method " + methodName + " could not be invoked on interface " + nativeInterface + "!", e2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterfaceDefinition
    implements Serializable {
        private int id;
        private Class<?>[] interfaces;
        private boolean isProxy;
        private boolean isNativeSide;

        private InterfaceDefinition(int id2, Class<?>[] interfaces, boolean isProxy, boolean isNativeSide) {
            this.id = id2;
            this.interfaces = interfaces;
            this.isProxy = isProxy;
            this.isNativeSide = isNativeSide;
        }

        public int getID() {
            return this.id;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }

        public boolean isProxy() {
            return this.isProxy;
        }

        public boolean isNativeSide() {
            return this.isNativeSide;
        }
    }

    private static class InterfaceInfo {
        private int id;

        public InterfaceInfo(Object intrface) {
            this.id = System.identityHashCode(intrface);
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o2) {
            return ((InterfaceInfo)o2).id == this.id;
        }
    }

    private static interface NativeSwingProxy {
        public void finalize();
    }

    private static class RunMethodResult
    implements Serializable {
        private Object result;
        private Object[] outParams;

        public RunMethodResult(Object result, Object[] outParams) {
            this.result = result;
            this.outParams = outParams;
        }

        public Object getResult() {
            return this.result;
        }

        public Object[] getOutParams() {
            return this.outParams;
        }
    }
}

