/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;
import chrriis.dj.nativeswing.swtimpl.components.VLCInput;
import java.io.File;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLCPlaylist {
    private JVLCPlayer vlcPlayer;
    private WebBrowserObject webBrowserObject;
    private volatile Thread playlistFixThread;

    VLCPlaylist(JVLCPlayer vlcPlayer) {
        this.vlcPlayer = vlcPlayer;
        this.webBrowserObject = vlcPlayer.getWebBrowserObject();
    }

    public int getItemCount() {
        Object value = this.webBrowserObject.getObjectProperty("playlist.items.count");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public boolean isPlaying() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("playlist.isPlaying"));
    }

    public void addItem(Class<?> clazz, String resourcePath) {
        this.addItem(clazz, resourcePath, null);
    }

    public void addItem(Class<?> clazz, String resourcePath, String options) {
        this.vlcPlayer.addReferenceClassLoader(clazz.getClassLoader());
        this.addItem(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void addItem(String resourcePath) {
        this.addItem(resourcePath, null);
    }

    public void addItem(String resourcePath, String options) {
        File file;
        if (!this.webBrowserObject.hasContent()) {
            this.vlcPlayer.load();
            this.clear();
        }
        if ((file = Utils.getLocalFile(resourcePath)) != null) {
            resourcePath = this.webBrowserObject.getLocalFileURL(file);
        }
        this.webBrowserObject.invokeObjectFunction("playlist.add", resourcePath, resourcePath, options);
    }

    public void play() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.play", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void playItem(int itemID) {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.playItem", itemID);
        this.setPlaylistFixActive(true);
    }

    public void togglePause() {
        this.webBrowserObject.invokeObjectFunction("playlist.togglePause", new Object[0]);
    }

    public void stop() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.stop", new Object[0]);
    }

    public void goNext() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.next", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void goPrevious() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.prev", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void clear() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.items.clear", new Object[0]);
    }

    public void removeItem(int index) {
        this.webBrowserObject.invokeObjectFunction("playlist.items.removeItem", index);
    }

    private void setPlaylistFixActive(boolean isActive) {
        if (this.playlistFixThread != null == isActive) {
            return;
        }
        if (isActive) {
            if (!Boolean.parseBoolean(NSSystemPropertySWT.VLCPLAYER_FIXPLAYLISTAUTOPLAYNEXT.get("true"))) {
                return;
            }
            this.playlistFixThread = new Thread("NativeSwing - VLC Player playlist fix"){

                public void run() {
                    final 1 currentThread = this;
                    boolean isFirst = true;
                    while (currentThread == VLCPlaylist.this.playlistFixThread) {
                        if (VLCPlaylist.this.vlcPlayer.isNativePeerDisposed()) {
                            VLCPlaylist.this.setPlaylistFixActive(false);
                            return;
                        }
                        try {
                            1.sleep(isFirst ? 3000 : 500);
                            isFirst = false;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (currentThread != VLCPlaylist.this.playlistFixThread) {
                                    return;
                                }
                                if (!VLCPlaylist.this.vlcPlayer.isNativePeerValid()) {
                                    return;
                                }
                                if (VLCPlaylist.this.vlcPlayer.getVLCInput().getMediaState() == VLCInput.VLCMediaState.ERROR) {
                                    VLCPlaylist.this.goNext();
                                }
                            }
                        });
                    }
                }
            };
            this.playlistFixThread.setDaemon(true);
            this.playlistFixThread.start();
        } else {
            this.playlistFixThread = null;
        }
    }
}

