/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;

public class NativeSwing {
    private static volatile List<NativeComponentWrapper> nativeComponentWrapperList;
    private static List<Window> windowList;
    private static volatile boolean isInitialized;
    private static volatile boolean isHeavyWeightForcerEnabled;

    static NativeComponentWrapper[] getNativeComponentWrappers() {
        if (nativeComponentWrapperList == null) {
            return new NativeComponentWrapper[0];
        }
        return nativeComponentWrapperList.toArray(new NativeComponentWrapper[0]);
    }

    static void addNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        NativeSwing.checkInitialized();
        if (nativeComponentWrapperList == null) {
            nativeComponentWrapperList = new ArrayList<NativeComponentWrapper>();
        }
        nativeComponentWrapperList.add(nativeComponentWrapper);
        if (!isHeavyWeightForcerEnabled) {
            HeavyweightForcer.activate(nativeComponentWrapper.getNativeComponent());
        }
    }

    static boolean removeNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        if (nativeComponentWrapperList == null) {
            return false;
        }
        return nativeComponentWrapperList.remove(nativeComponentWrapper);
    }

    static Window[] getWindows() {
        return windowList == null ? new Window[]{} : windowList.toArray(new Window[0]);
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    private static void checkInitialized() {
        if (!NativeSwing.isInitialized()) {
            throw new IllegalStateException("The Native Swing framework is not initialized! Please refer to the instructions to set it up properly.");
        }
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initialize() {
        boolean isSunMixingEnabled;
        if (NativeSwing.isInitialized()) {
            return;
        }
        NativeSwing.loadClipboardDebuggingProperties();
        SystemProperty.SUN_AWT_NOERASEBACKGROUND.set("true");
        SystemProperty.SUN_AWT_XEMBEDSERVER.set("true");
        NSSystemProperty.JNA_FORCE_HW_POPUP.set("false");
        if (SystemProperty.JAVAWEBSTART_VERSION.get() != null && SystemProperty.JAVA_VERSION.get().compareTo("1.6.0_18") >= 0) {
            if (SystemProperty.SUN_AWT_DISABLEMIXING.get() == null) {
                System.err.println("Under WebStart on Java >= 1.6.0_18, the value of the \"" + SystemProperty.SUN_AWT_DISABLEMIXING.getName() + "\" system property needs to be defined in the JNLP descriptor with value \"true\" (or \"false\" if you really want the default behavior). When not set to \"true\", the content of the native components may not be displayed.");
                SystemProperty.SUN_AWT_DISABLEMIXING.set("false");
            }
        } else if (SystemProperty.SUN_AWT_DISABLEMIXING.get() == null) {
            SystemProperty.SUN_AWT_DISABLEMIXING.set("true");
        }
        isHeavyWeightForcerEnabled = isSunMixingEnabled = !"true".equals(SystemProperty.SUN_AWT_DISABLEMIXING.get()) && SystemProperty.JAVA_VERSION.get().compareTo("1.6.0_12") >= 0;
        NSSystemProperty.INTEGRATION_USEDEFAULTCLIPPING.set(String.valueOf(isSunMixingEnabled));
        long flags = 65L;
        if (Utils.IS_JAVA_7_OR_GREATER) {
            flags |= 0x14L;
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new NIAWTEventListener(), flags);
        isInitialized = true;
    }

    private NativeSwing() {
    }

    private static class HeavyweightForcer
    implements HierarchyListener {
        private Component component;
        private HeavyweightForcerWindow forcer;

        private HeavyweightForcer(Component component) {
            this.component = component;
            if (component.isShowing()) {
                this.createForcer();
            }
        }

        public static void activate(Component component) {
            component.addHierarchyListener(new HeavyweightForcer(component));
        }

        private void destroyForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HeavyweightForcer.this.destroyForcer();
                    }
                });
                return;
            }
            if (this.forcer == null) {
                return;
            }
            int count = this.forcer.getCount() - 1;
            this.forcer.setCount(count);
            if (count == 0) {
                this.forcer.dispose();
            }
            this.forcer = null;
        }

        private void createForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HeavyweightForcer.this.createForcer();
                    }
                });
                return;
            }
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.component);
            if (windowAncestor == null) {
                return;
            }
            Window[] windowArray = windowAncestor.getOwnedWindows();
            int n2 = windowArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Window window = windowArray[n3];
                if (window instanceof HeavyweightForcerWindow) {
                    this.forcer = (HeavyweightForcerWindow)window;
                    break;
                }
                ++n3;
            }
            if (this.forcer == null) {
                this.forcer = new HeavyweightForcerWindow(windowAncestor);
            }
            this.forcer.setCount(this.forcer.getCount() + 1);
        }

        public void hierarchyChanged(HierarchyEvent e2) {
            long changeFlags = e2.getChangeFlags();
            if ((changeFlags & 2L) != 0L) {
                if (!this.component.isDisplayable()) {
                    this.component.removeHierarchyListener(this);
                    this.destroyForcer();
                }
            } else if ((changeFlags & 4L) != 0L) {
                if (this.component.isShowing()) {
                    this.createForcer();
                } else {
                    this.destroyForcer();
                }
            }
        }
    }

    private static class HeavyweightForcerWindow
    extends Window {
        private boolean isPacked;
        private int count;

        public HeavyweightForcerWindow(Window parent) {
            super(parent);
            this.pack();
            this.isPacked = true;
        }

        public boolean isVisible() {
            return this.isPacked;
        }

        public Rectangle getBounds() {
            Window owner = this.getOwner();
            return owner == null ? super.getBounds() : owner.getBounds();
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class NIAWTEventListener
    implements AWTEventListener {
        private List<Dialog> dialogList = new ArrayList<Dialog>();
        private volatile Set<Window> blockedWindowSet = new HashSet<Window>();

        private NIAWTEventListener() {
        }

        private static boolean isDescendant(Window window, Window ancestorWindow) {
            while (window != null) {
                if (window == ancestorWindow) {
                    return true;
                }
                window = window.getOwner();
            }
            return false;
        }

        private void computeBlockedDialogs() {
            this.blockedWindowSet.clear();
            Window[] windows = NativeSwing.getWindows();
            ArrayList<Dialog> applicationModalDialogList = new ArrayList<Dialog>();
            for (Dialog dialog : this.dialogList) {
                if (!dialog.isVisible()) continue;
                boolean isApplicationModal = false;
                if (Utils.IS_JAVA_6_OR_GREATER) {
                    switch (dialog.getModalityType()) {
                        case APPLICATION_MODAL: 
                        case TOOLKIT_MODAL: {
                            isApplicationModal = true;
                        }
                    }
                } else if (dialog.isModal()) {
                    isApplicationModal = true;
                }
                if (!isApplicationModal) continue;
                applicationModalDialogList.add(dialog);
            }
            if (!applicationModalDialogList.isEmpty()) {
                int i2 = 0;
                while (i2 < windows.length) {
                    Window window = windows[i2];
                    boolean isIncluded = false;
                    for (Dialog applicationModalDialog : applicationModalDialogList) {
                        if (window != applicationModalDialog && !NIAWTEventListener.isDescendant(window, applicationModalDialog)) {
                            isIncluded = true;
                            int j2 = 0;
                            while (j2 < i2) {
                                if (windows[j2] == applicationModalDialog) {
                                    isIncluded = false;
                                    break;
                                }
                                ++j2;
                            }
                            if (isIncluded && Utils.IS_JAVA_6_OR_GREATER) {
                                switch (window.getModalExclusionType()) {
                                    case APPLICATION_EXCLUDE: 
                                    case TOOLKIT_EXCLUDE: {
                                        isIncluded = false;
                                    }
                                }
                            }
                        }
                        if (isIncluded) break;
                    }
                    if (isIncluded) {
                        this.blockedWindowSet.add(window);
                    }
                    ++i2;
                }
            }
            if (Utils.IS_JAVA_6_OR_GREATER) {
                int i3 = this.dialogList.size() - 1;
                while (i3 >= 0) {
                    Dialog dialog = this.dialogList.get(i3);
                    if (dialog.isVisible() && !this.blockedWindowSet.contains(dialog)) {
                        switch (dialog.getModalityType()) {
                            case DOCUMENT_MODAL: {
                                Window hierarchyOwnerWindow;
                                Window owner = hierarchyOwnerWindow = dialog.getOwner();
                                while (owner != null) {
                                    hierarchyOwnerWindow = owner;
                                    owner = owner.getOwner();
                                }
                                if (hierarchyOwnerWindow == null) break;
                                Window[] windowArray = windows;
                                int n2 = windows.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    Window window = windowArray[n3];
                                    if (window != dialog && !NIAWTEventListener.isDescendant(window, dialog) && (window == hierarchyOwnerWindow || NIAWTEventListener.isDescendant(window, hierarchyOwnerWindow))) {
                                        this.blockedWindowSet.add(window);
                                    }
                                    ++n3;
                                }
                                break;
                            }
                        }
                    }
                    --i3;
                }
            }
        }

        private void adjustNativeComponents() {
            if (nativeComponentWrapperList == null) {
                return;
            }
            int i2 = nativeComponentWrapperList.size() - 1;
            while (i2 >= 0) {
                Component component;
                NativeComponentWrapper nativeComponentWrapper = (NativeComponentWrapper)nativeComponentWrapperList.get(i2);
                Component c2 = component = nativeComponentWrapper.getNativeComponent();
                NativeComponentProxy componentProxy = nativeComponentWrapper.getNativeComponentProxy();
                if (componentProxy != null) {
                    c2 = componentProxy;
                }
                Window embedderWindowAncestor = SwingUtilities.getWindowAncestor(c2);
                boolean isBlocked = this.blockedWindowSet.contains(embedderWindowAncestor);
                boolean isShowing = c2.isShowing();
                nativeComponentWrapper.setNativeComponentEnabled(!isBlocked && isShowing);
                if (!Utils.IS_MAC && !isShowing && component.hasFocus()) {
                    component.transferFocus();
                }
                --i2;
            }
        }

        public void eventDispatched(AWTEvent e2) {
            Dialog d2;
            int eventID = e2.getID();
            if (Utils.IS_JAVA_7_OR_GREATER) {
                switch (eventID) {
                    case 501: 
                    case 1004: {
                        if (nativeComponentWrapperList == null) {
                            return;
                        }
                        int i2 = nativeComponentWrapperList.size() - 1;
                        while (i2 >= 0) {
                            NativeComponentWrapper nativeComponentWrapper = (NativeComponentWrapper)nativeComponentWrapperList.get(i2);
                            if (nativeComponentWrapper.isNativeComponentEnabled()) {
                                nativeComponentWrapper.setNativeComponentEnabled(false);
                                nativeComponentWrapper.setNativeComponentEnabled(true);
                            }
                            --i2;
                        }
                        return;
                    }
                }
            }
            boolean isAdjusting = false;
            switch (eventID) {
                case 102: 
                case 103: {
                    isAdjusting = true;
                }
            }
            if (e2.getSource() instanceof Window) {
                if (windowList == null) {
                    windowList = new ArrayList();
                }
                switch (eventID) {
                    case 102: 
                    case 200: {
                        Window w2 = (Window)e2.getSource();
                        windowList.remove(w2);
                        windowList.add(w2);
                        break;
                    }
                    case 103: 
                    case 202: {
                        windowList.remove(e2.getSource());
                    }
                }
            }
            if (e2.getSource() instanceof Dialog) {
                switch (eventID) {
                    case 102: 
                    case 200: {
                        d2 = (Dialog)e2.getSource();
                        this.dialogList.remove(d2);
                        this.dialogList.add(d2);
                        break;
                    }
                    case 103: 
                    case 202: {
                        this.dialogList.remove(e2.getSource());
                    }
                }
                switch (eventID) {
                    case 102: 
                    case 103: 
                    case 200: 
                    case 202: {
                        this.computeBlockedDialogs();
                        isAdjusting = true;
                    }
                }
            }
            if (isAdjusting) {
                this.adjustNativeComponents();
            }
            switch (eventID) {
                case 208: {
                    if (!(e2.getSource() instanceof Dialog) || !(d2 = (Dialog)e2.getSource()).getFocusableWindowState()) break;
                    d2.setFocusableWindowState(false);
                    Thread t2 = new Thread("Dialog focus fixer"){

                        public void run() {
                            try {
                                1.sleep(125L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    d2.setFocusableWindowState(true);
                                }
                            });
                        }
                    };
                    t2.setDaemon(true);
                    t2.start();
                }
            }
        }
    }
}

