/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.common.MimeTypes;
import chrriis.common.ObjectRegistry;
import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSSystemProperty;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class WebServer {
    private int port;
    private volatile boolean isRunning;
    private volatile ServerSocket serverSocket;
    private volatile int instanceID;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);
    private List<WebServerContentProvider> contentProviderList = new ArrayList<WebServerContentProvider>();
    private static WebServer webServer;
    private static Object LOCK;
    private static String hostAddress;

    static {
        LOCK = new Object();
        String hostAddress = Utils.getLocalHostAddress();
        if (hostAddress == null) {
            hostAddress = "127.0.0.1";
        }
        WebServer.hostAddress = hostAddress;
    }

    public WebServer() {
        this(0);
    }

    public WebServer(int port) {
        this.port = port;
    }

    public void stop() {
        this.isRunning = false;
        if (this.serverSocket != null) {
            ServerSocket serverSocket = this.serverSocket;
            this.serverSocket = null;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() throws IOException {
        this.start(true);
    }

    public void start(boolean isDaemon) throws IOException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.instanceID = ObjectRegistry.getInstance().add(this);
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(WebServer.getHostAddress()), this.port));
        this.port = this.serverSocket.getLocalPort();
        if (Boolean.parseBoolean(NSSystemProperty.WEBSERVER_DEBUG_PRINTPORT.get())) {
            System.err.println("Web Server port: " + this.port);
        }
        Thread listenerThread = new Thread("WebServer"){

            public void run() {
                while (WebServer.this.isRunning) {
                    try {
                        Socket socket = WebServer.this.serverSocket.accept();
                        socket.setSoTimeout(10000);
                        try {
                            WebServerConnectionThread.semaphore.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        WebServerConnectionThread webServerConnectionThread = new WebServerConnectionThread(socket);
                        webServerConnectionThread.start();
                    }
                    catch (Exception e2) {
                        if (WebServer.this.serverSocket == null) continue;
                        e2.printStackTrace();
                    }
                }
                WebServer.this.serverSocket = null;
                ObjectRegistry.getInstance().remove(WebServer.this.instanceID);
            }
        };
        listenerThread.setDaemon(isDaemon);
        listenerThread.start();
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPrefix() {
        if (hostAddress.indexOf(58) >= 0) {
            return "http://[" + hostAddress + "]:" + this.port;
        }
        return "http://" + hostAddress + ":" + this.port;
    }

    public String getDynamicContentURL(String className, String parameter) {
        return String.valueOf(this.getURLPrefix()) + "/class/" + this.instanceID + "/" + className + "/" + Utils.encodeURL(parameter);
    }

    public String getDynamicContentURL(String className, String codebase, String parameter) {
        return String.valueOf(this.getURLPrefix()) + "/class/" + this.instanceID + "/" + className + "/" + codebase + "/" + Utils.encodeURL(parameter);
    }

    public String getClassPathResourceURL(String className, String resourcePath) {
        if (!resourcePath.startsWith("/")) {
            String classPath = className.replace('.', '/');
            classPath = classPath.substring(0, classPath.lastIndexOf(47) + 1);
            resourcePath = "/" + classPath + resourcePath;
        }
        return String.valueOf(this.getURLPrefix()) + "/classpath/" + this.instanceID + Utils.simplifyPath(resourcePath);
    }

    public String getResourcePathURL(String codeBase, String resourcePath) {
        if (codeBase == null) {
            codeBase = new File(SystemProperty.USER_DIR.get()).getAbsolutePath();
        }
        if (Boolean.parseBoolean(NSSystemProperty.WEBSERVER_ACTIVATEOLDRESOURCEMETHOD.get())) {
            if (Utils.IS_WINDOWS) {
                codeBase = codeBase.replace('\\', '/');
                resourcePath = resourcePath.replace('\\', '/');
            }
            return String.valueOf(this.getURLPrefix()) + "/resource/" + Utils.encodeURL(codeBase) + "/" + Utils.encodeURL(resourcePath);
        }
        return String.valueOf(this.getURLPrefix()) + "/location/" + Utils.encodeBase64(codeBase, true) + "/" + Utils.encodeURL(resourcePath);
    }

    public WebServerContent getURLContent(String resourceURL) {
        try {
            HTTPRequest httpRequest = new HTTPRequest(new URL(resourceURL).getPath(), null);
            return WebServer.getWebServerContent(httpRequest);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader()) {
            return;
        }
        this.referenceClassLoaderList.add(0, referenceClassLoader);
    }

    public void removeReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader()) {
            return;
        }
        this.referenceClassLoaderList.remove(referenceClassLoader);
    }

    public void addContentProvider(WebServerContentProvider webServerContentProvider) {
        this.contentProviderList.add(webServerContentProvider);
    }

    public void removeContentProvider(WebServerContentProvider webServerContentProvider) {
        this.contentProviderList.remove(webServerContentProvider);
    }

    protected static WebServerContent getWebServerContent(HTTPRequest httpRequest) {
        int index;
        String parameter = httpRequest.getResourcePath();
        if (parameter.startsWith("/")) {
            parameter = parameter.substring(1);
        }
        if ((index = parameter.indexOf(47)) != -1) {
            String type = parameter.substring(0, index);
            parameter = parameter.substring(index + 1);
            if ("class".equals(type)) {
                index = parameter.indexOf(47);
                WebServer webServer = (WebServer)ObjectRegistry.getInstance().get(Integer.parseInt(parameter.substring(0, index)));
                if (webServer == null) {
                    return null;
                }
                parameter = parameter.substring(index + 1);
                index = parameter.indexOf(47);
                String className = parameter.substring(0, index);
                parameter = Utils.decodeURL(parameter.substring(index + 1));
                httpRequest = httpRequest.clone();
                try {
                    Class<?> clazz = null;
                    for (ClassLoader referenceClassLoader : webServer.referenceClassLoaderList) {
                        try {
                            clazz = Class.forName(className, true, referenceClassLoader);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (clazz == null) {
                        clazz = Class.forName(className);
                    }
                    Method getWebServerContentMethod = clazz.getDeclaredMethod("getWebServerContent", HTTPRequest.class);
                    getWebServerContentMethod.setAccessible(true);
                    httpRequest.setResourcePath(parameter);
                    return (WebServerContent)getWebServerContentMethod.invoke(null, httpRequest);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return null;
                }
            }
            if ("classpath".equals(type)) {
                index = parameter.indexOf(47);
                final WebServer webServer = (WebServer)ObjectRegistry.getInstance().get(Integer.parseInt(parameter.substring(0, index)));
                if (webServer == null) {
                    return null;
                }
                parameter = parameter.substring(index + 1);
                final String resourcePath = Utils.decodeURL(WebServer.removeHTMLAnchor(parameter));
                return new WebServerContent(){

                    public String getContentType() {
                        int index = resourcePath.lastIndexOf(46);
                        return 2.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                    }

                    public InputStream getInputStream() {
                        try {
                            for (ClassLoader referenceClassLoader : webServer.referenceClassLoaderList) {
                                InputStream in = referenceClassLoader.getResourceAsStream(resourcePath);
                                if (in == null) continue;
                                return in;
                            }
                            return WebServer.class.getResourceAsStream(String.valueOf('/') + resourcePath);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            return null;
                        }
                    }
                };
            }
            if ("location".equals(type)) {
                String resourceURL;
                index = parameter.indexOf(47);
                String codeBase = Utils.decodeBase64(parameter.substring(0, index));
                parameter = Utils.decodeURL(WebServer.removeHTMLAnchor(parameter.substring(index + 1)));
                try {
                    URL url = new URL(codeBase);
                    int port = url.getPort();
                    resourceURL = String.valueOf(url.getProtocol()) + "://" + url.getHost() + (port != -1 ? ":" + port : "");
                    if (parameter.startsWith("/")) {
                        resourceURL = String.valueOf(resourceURL) + parameter;
                    } else {
                        String path = url.getPath();
                        path = String.valueOf(path.substring(0, path.lastIndexOf(47) + 1)) + parameter;
                        resourceURL = String.valueOf(resourceURL) + (path.startsWith("/") ? path : "/" + path);
                    }
                }
                catch (Exception e3) {
                    File file = Utils.getLocalFile(new File(codeBase, parameter).getAbsolutePath());
                    resourceURL = file != null ? new File(codeBase, parameter).toURI().toString() : String.valueOf(codeBase) + "/" + parameter;
                }
                final String resourceURL_ = resourceURL;
                return new WebServerContent(){

                    public long getContentLength() {
                        File file = Utils.getLocalFile(resourceURL_);
                        if (file != null) {
                            return file.length();
                        }
                        return super.getContentLength();
                    }

                    public String getContentType() {
                        int index = resourceURL_.lastIndexOf(46);
                        return 3.getDefaultMimeType(index == -1 ? null : resourceURL_.substring(index));
                    }

                    public InputStream getInputStream() {
                        try {
                            return new URL(resourceURL_).openStream();
                        }
                        catch (Exception exception) {
                            try {
                                return new FileInputStream("/" + resourceURL_);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                return null;
                            }
                        }
                    }
                };
            }
            if ("resource".equals(type)) {
                String resourceURL;
                String subs;
                index = parameter.indexOf(47);
                if (index > 0 && (subs = parameter.substring(index - 1)).startsWith("://")) {
                    index = parameter.indexOf(47, index + 2);
                }
                String codeBase = Utils.decodeURL(parameter.substring(0, index));
                parameter = Utils.decodeURL(parameter.substring(index + 1));
                try {
                    URL url = new URL(codeBase);
                    int port = url.getPort();
                    resourceURL = String.valueOf(url.getProtocol()) + "://" + url.getHost() + (port != -1 ? ":" + port : "");
                    if (parameter.startsWith("/")) {
                        resourceURL = String.valueOf(resourceURL) + WebServer.removeHTMLAnchor(parameter);
                    } else {
                        String path = url.getPath();
                        path = String.valueOf(path.substring(0, path.lastIndexOf(47) + 1)) + parameter;
                        resourceURL = String.valueOf(resourceURL) + (path.startsWith("/") ? path : "/" + path);
                    }
                }
                catch (Exception e4) {
                    File file = Utils.getLocalFile(new File(codeBase, WebServer.removeHTMLAnchor(parameter)).getAbsolutePath());
                    resourceURL = file != null ? new File(codeBase, WebServer.removeHTMLAnchor(parameter)).toURI().toString() : String.valueOf(codeBase) + "/" + WebServer.removeHTMLAnchor(parameter);
                }
                final String resourceURL_ = resourceURL;
                return new WebServerContent(){

                    public long getContentLength() {
                        File file = Utils.getLocalFile(resourceURL_);
                        if (file != null) {
                            return file.length();
                        }
                        return super.getContentLength();
                    }

                    public String getContentType() {
                        int index = resourceURL_.lastIndexOf(46);
                        return 4.getDefaultMimeType(index == -1 ? null : resourceURL_.substring(index));
                    }

                    public InputStream getInputStream() {
                        try {
                            return new URL(resourceURL_).openStream();
                        }
                        catch (Exception exception) {
                            try {
                                return new FileInputStream("/" + resourceURL_);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                                return null;
                            }
                        }
                    }
                };
            }
        }
        for (WebServerContentProvider contentProvider : WebServer.webServer.contentProviderList) {
            WebServerContent webServerContent = contentProvider.getWebServerContent(httpRequest);
            if (webServerContent == null) continue;
            return webServerContent;
        }
        return null;
    }

    private static String removeHTMLAnchor(String location) {
        int anchorIndex = location.indexOf(35);
        if (anchorIndex > 0) {
            location = location.substring(0, anchorIndex);
        }
        return location;
    }

    private static String getHostAddress() {
        return hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopDefaultWebServer() {
        Object object = LOCK;
        synchronized (object) {
            if (webServer != null) {
                webServer.stop();
                webServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServer getDefaultWebServer() {
        Object object = LOCK;
        synchronized (object) {
            if (webServer != null) {
                return webServer;
            }
            webServer = new WebServer();
            try {
                boolean isApplet = "applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get());
                webServer.start(!isApplet);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return webServer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTTPData {
        private Map<String, String> headerMap = new HashMap<String, String>();
        private byte[] bytes;

        HTTPData() {
        }

        public Map<String, String> getHeaderMap() {
            return this.headerMap;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTTPRequest
    implements Cloneable {
        private Map<String, String> headerMap;
        private String endQuery = "";
        private String urlPath;
        private String resourcePath;
        private String anchor;
        private Map<String, String> queryParameterMap = new HashMap<String, String>();
        private boolean isPostMethod;
        private HTTPData[] httpPostDataArray;

        HTTPRequest(String urlPath, Map<String, String> headerMap) {
            this.headerMap = headerMap == null ? new HashMap() : headerMap;
            this.setURLPath(urlPath);
        }

        public Map<String, String> getHeaderMap() {
            return this.headerMap;
        }

        void setURLPath(String urlPath) {
            this.urlPath = urlPath;
            this.resourcePath = urlPath;
            int index = this.resourcePath.indexOf(63);
            if (index != -1) {
                String queryString = this.resourcePath.substring(index + 1);
                this.endQuery = String.valueOf('?') + queryString;
                this.resourcePath = this.resourcePath.substring(0, index);
                String[] stringArray = queryString.split("&");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String content = stringArray[n3];
                    int eqIndex = content.indexOf(61);
                    if (eqIndex > 0) {
                        String key = content.substring(0, eqIndex);
                        String value = Utils.decodeURL(content.substring(eqIndex + 1));
                        this.queryParameterMap.put(key, value);
                    } else {
                        this.queryParameterMap.put(content, "");
                    }
                    ++n3;
                }
            }
            if ((index = this.resourcePath.indexOf(35)) != -1) {
                this.anchor = this.resourcePath.substring(index + 1);
                this.endQuery = String.valueOf('#') + this.anchor + this.endQuery;
                this.resourcePath = this.resourcePath.substring(0, index);
            }
        }

        public String getURLPath() {
            return this.urlPath;
        }

        void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            this.urlPath = String.valueOf(resourcePath) + this.endQuery;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public Map<String, String> getQueryParameterMap() {
            return this.queryParameterMap;
        }

        void setPostMethod(boolean isPostMethod) {
            this.isPostMethod = isPostMethod;
        }

        public boolean isPostMethod() {
            return this.isPostMethod;
        }

        void setHTTPPostDataArray(HTTPData[] httpPostDataArray) {
            this.httpPostDataArray = httpPostDataArray;
        }

        public HTTPData[] getHTTPPostDataArray() {
            return this.httpPostDataArray;
        }

        protected HTTPRequest clone() {
            try {
                HTTPRequest httpRequest = (HTTPRequest)super.clone();
                httpRequest.queryParameterMap = new HashMap<String, String>(this.queryParameterMap);
                return httpRequest;
            }
            catch (CloneNotSupportedException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static class WebServerConnectionThread
    extends Thread {
        private static int threadInitNumber;
        private static Semaphore semaphore;
        private Socket socket;
        private static final String LS;

        static {
            semaphore = new Semaphore(10);
            LS = Utils.LINE_SEPARATOR;
        }

        private static synchronized int nextThreadNumber() {
            return threadInitNumber++;
        }

        public WebServerConnectionThread(Socket socket) {
            super("WebServer Connection-" + WebServerConnectionThread.nextThreadNumber());
            this.socket = socket;
            this.setDaemon(true);
        }

        static void writeHTTPHeaders(BufferedOutputStream out, int code, String contentType, long contentLength, long lastModified) {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP/1.0 " + code + " OK" + LS);
            sb.append("Content-Type: " + contentType + LS);
            sb.append("Server: WebServer/1.0" + LS);
            sb.append("Date: " + new Date() + LS);
            if (contentLength != -1L) {
                sb.append("Content-Length: " + contentLength + LS);
            }
            sb.append(LS);
            try {
                out.write(sb.toString().getBytes("UTF-8"));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }

        static void writeHTTPError(BufferedOutputStream out, int code, String message) {
            WebServerConnectionThread.writeHTTPHeaders(out, code, "text/html", message.length(), System.currentTimeMillis());
            try {
                out.write(message.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void run() {
            try {
                long printDataCount;
                boolean isPrintDataDebug;
                boolean isPrintRequestsDebug;
                InputStream resourceStream_;
                WebServerContent webServerContent;
                String resourcePath;
                boolean isPostMethod;
                BufferedOutputStream out;
                HTTPInputStream in;
                block51: {
                    String header;
                    String request;
                    block50: {
                        block49: {
                            in = new HTTPInputStream(new BufferedInputStream(this.socket.getInputStream()));
                            out = new BufferedOutputStream(this.socket.getOutputStream());
                            request = in.readAsciiLine();
                            if (request != null && (request.endsWith(" HTTP/1.0") || request.endsWith("HTTP/1.1"))) break block49;
                            WebServerConnectionThread.writeHTTPError(out, 500, "Invalid Method.");
                            out.flush();
                            out.close();
                            in.close();
                            this.socket.close();
                            return;
                        }
                        isPostMethod = false;
                        if (request.startsWith("POST ")) {
                            isPostMethod = true;
                            break block50;
                        }
                        if (request.startsWith("GET ")) break block50;
                        WebServerConnectionThread.writeHTTPError(out, 500, "Invalid Method.");
                        out.flush();
                        out.close();
                        in.close();
                        this.socket.close();
                        return;
                    }
                    resourcePath = request.substring((isPostMethod ? "POST " : "GET ").length(), request.length() - " HTTP/1.0".length());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    while ((header = in.readAsciiLine()).length() > 0) {
                        int index = header.indexOf(": ");
                        if (index <= 0) continue;
                        headerMap.put(header.substring(0, index), header.substring(index + ": ".length()));
                    }
                    HTTPRequest httpRequest = new HTTPRequest(resourcePath, headerMap);
                    httpRequest.setPostMethod(isPostMethod);
                    if (isPostMethod) {
                        HTTPData[] httpDataArray;
                        int contentLength;
                        String contentType = (String)headerMap.get("Content-Type");
                        String contentLengthString = (String)headerMap.get("Content-Length");
                        int n2 = contentLength = contentLengthString == null ? -1 : Integer.parseInt(contentLengthString);
                        if (contentType != null && contentType.startsWith("multipart/")) {
                            byte[] dataBytes;
                            if (contentLength > 0) {
                                dataBytes = new byte[contentLength];
                                in.read(dataBytes);
                            } else {
                                int i2;
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                byte[] bytes = new byte[1024];
                                while ((i2 = in.read(bytes)) != -1) {
                                    baos.write(bytes, 0, i2);
                                }
                                dataBytes = baos.toByteArray();
                            }
                            String boundary = "--" + contentType.substring(contentType.indexOf("boundary=") + "boundary=".length());
                            byte[] boundaryBytes = boundary.getBytes("UTF-8");
                            ArrayList<Integer> indexList = new ArrayList<Integer>();
                            int i3 = 0;
                            while (i3 < dataBytes.length - boundaryBytes.length) {
                                boolean isFound = true;
                                int j2 = 0;
                                while (j2 < boundaryBytes.length) {
                                    if (dataBytes[i3 + j2] != boundaryBytes[j2]) {
                                        isFound = false;
                                        break;
                                    }
                                    ++j2;
                                }
                                if (isFound) {
                                    indexList.add(i3);
                                    i3 += boundaryBytes.length;
                                }
                                ++i3;
                            }
                            httpDataArray = new HTTPData[indexList.size() - 1];
                            i3 = 0;
                            while (i3 < httpDataArray.length) {
                                int n3;
                                String header2;
                                HTTPData httpData2;
                                httpDataArray[i3] = httpData2 = new HTTPData();
                                int start = (Integer)indexList.get(i3);
                                ByteArrayInputStream bais = new ByteArrayInputStream(dataBytes, start, (Integer)indexList.get(i3 + 1) - start - in.getLineSeparator().length());
                                HTTPInputStream din = new HTTPInputStream(bais);
                                din.readAsciiLine();
                                Map<String, String> dataHeaderMap = httpData2.getHeaderMap();
                                while ((header2 = din.readAsciiLine()).length() > 0) {
                                    String key = header2.substring(header2.indexOf(": "));
                                    String value = header2.substring(key.length() + ": ".length());
                                    dataHeaderMap.put(key, value);
                                }
                                ByteArrayOutputStream aos = new ByteArrayOutputStream();
                                while ((n3 = din.read()) != -1) {
                                    aos.write(n3);
                                }
                                httpData2.setBytes(aos.toByteArray());
                                ++i3;
                            }
                        } else {
                            String dataContent;
                            InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
                            if (contentLength > 0) {
                                char[] chars = new char[contentLength];
                                int offset = 0;
                                while (chars.length > offset) {
                                    int n4 = reader.read(chars, offset, chars.length - offset);
                                    int n5 = offset = n4 == -1 ? chars.length : offset + n4;
                                }
                                dataContent = new String(chars);
                            } else {
                                int i4;
                                StringBuilder sb = new StringBuilder();
                                char[] chars = new char[1024];
                                while ((i4 = reader.read(chars)) != -1) {
                                    sb.append(chars, 0, i4);
                                }
                                dataContent = sb.toString();
                            }
                            HTTPData httpData = new HTTPData();
                            Map<String, String> dataHeaderMap = httpData.getHeaderMap();
                            String[] stringArray = dataContent.split("&");
                            int n6 = stringArray.length;
                            int httpData2 = 0;
                            while (httpData2 < n6) {
                                String content = stringArray[httpData2];
                                int eqIndex = content.indexOf(61);
                                if (eqIndex > 0) {
                                    String key = content.substring(0, eqIndex);
                                    String value = Utils.decodeURL(content.substring(eqIndex + 1));
                                    dataHeaderMap.put(key, value);
                                } else {
                                    dataHeaderMap.put(content, "");
                                }
                                ++httpData2;
                            }
                            httpDataArray = new HTTPData[]{httpData};
                        }
                        httpRequest.setHTTPPostDataArray(httpDataArray);
                    }
                    webServerContent = WebServer.getWebServerContent(httpRequest);
                    resourceStream_ = null;
                    if (webServerContent != null) {
                        try {
                            resourceStream_ = webServerContent.getInputStream();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    isPrintRequestsDebug = Boolean.parseBoolean(NSSystemProperty.WEBSERVER_DEBUG_PRINTREQUESTS.get());
                    String printDataProperty = NSSystemProperty.WEBSERVER_DEBUG_PRINTDATA.get();
                    isPrintDataDebug = false;
                    printDataCount = -1L;
                    if (printDataProperty != null) {
                        try {
                            printDataCount = Long.parseLong(printDataProperty);
                            isPrintDataDebug = true;
                        }
                        catch (Exception e3) {
                            isPrintDataDebug = Boolean.parseBoolean(printDataProperty);
                            printDataCount = Integer.MAX_VALUE;
                        }
                    }
                    if (resourceStream_ != null) break block51;
                    if (isPrintRequestsDebug) {
                        System.err.println("Web Server " + (isPostMethod ? "POST" : "GET") + ": " + resourcePath + " -> 404 (not found)");
                    }
                    WebServerConnectionThread.writeHTTPError(out, 404, "File Not Found.");
                    out.flush();
                    out.close();
                    in.close();
                    this.socket.close();
                    return;
                }
                try {
                    try {
                        int i5;
                        if (isPrintRequestsDebug || isPrintDataDebug) {
                            System.err.println("Web Server " + (isPostMethod ? "POST" : "GET") + ": " + resourcePath + " -> 200 (OK)");
                        }
                        BufferedInputStream resourceStream = new BufferedInputStream(resourceStream_);
                        WebServerConnectionThread.writeHTTPHeaders(out, 200, webServerContent.getContentType(), webServerContent.getContentLength(), webServerContent.getLastModified());
                        byte[] bytes = new byte[4096];
                        while ((i5 = resourceStream.read(bytes)) != -1) {
                            if (isPrintDataDebug && i5 > 0 && printDataCount > 0L) {
                                System.err.print(new String(bytes, 0, (int)Math.min((long)i5, printDataCount), "UTF-8"));
                                printDataCount -= (long)i5;
                            }
                            out.write(bytes, 0, i5);
                        }
                        if (isPrintDataDebug) {
                            System.err.println();
                        }
                        try {
                            resourceStream.close();
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        out.flush();
                        out.close();
                        in.close();
                        this.socket.close();
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                semaphore.release();
            }
        }

        private static class HTTPInputStream
        extends InputStream {
            private InputStream inputStream;
            private LineSeparator lineSeparator;
            private int lastByte = -1;

            public HTTPInputStream(InputStream inputStream) {
                this.inputStream = inputStream;
            }

            public String getLineSeparator() {
                switch (this.lineSeparator) {
                    case CR: {
                        return "\r";
                    }
                    case LF: {
                        return "\n";
                    }
                    case CRLF: {
                        return "\r\n";
                    }
                }
                return null;
            }

            public String readAsciiLine() throws IOException {
                if (this.lineSeparator == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (true) {
                        int b2;
                        if ((b2 = this.read()) == -1) {
                            return null;
                        }
                        if (b2 == 10) {
                            this.lineSeparator = LineSeparator.LF;
                            return new String(baos.toByteArray(), "UTF-8");
                        }
                        if (b2 == 13) {
                            int b22 = this.read();
                            if (b22 == 10) {
                                this.lineSeparator = LineSeparator.CRLF;
                            } else {
                                this.lineSeparator = LineSeparator.CR;
                                if (b22 != -1) {
                                    this.lastByte = b22;
                                }
                            }
                            return new String(baos.toByteArray(), "UTF-8");
                        }
                        baos.write(b2);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (this.lastByte != -1) {
                    baos.write(this.lastByte);
                    this.lastByte = -1;
                }
                switch (this.lineSeparator) {
                    case CR: {
                        int b3;
                        while ((b3 = this.read()) != 13 && b3 != -1) {
                            baos.write(b3);
                        }
                        break;
                    }
                    case LF: {
                        int b4;
                        while ((b4 = this.read()) != 10 && b4 != -1) {
                            baos.write(b4);
                        }
                        break;
                    }
                    case CRLF: {
                        int b5;
                        while ((b5 = this.read()) != 13 && b5 != -1) {
                            baos.write(b5);
                        }
                        this.read();
                    }
                }
                return new String(baos.toByteArray(), "UTF-8");
            }

            public void close() throws IOException {
                this.inputStream.close();
            }

            public int read(byte[] b2) throws IOException {
                return this.inputStream.read(b2);
            }

            public int read(byte[] b2, int off, int len) throws IOException {
                return this.inputStream.read(b2, off, len);
            }

            public int read() throws IOException {
                int n2 = this.inputStream.read();
                return n2;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum LineSeparator {
                CR,
                LF,
                CRLF;

            }
        }
    }

    public static abstract class WebServerContent {
        private static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";

        public static String getDefaultMimeType(String extension) {
            String mimeType = MimeTypes.getMimeType(extension);
            return mimeType == null ? MIME_APPLICATION_OCTET_STREAM : mimeType;
        }

        public abstract InputStream getInputStream();

        public static InputStream getInputStream(String content) {
            if (content == null) {
                return null;
            }
            try {
                return new ByteArrayInputStream(content.getBytes("UTF-8"));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }

        public String getContentType() {
            return WebServerContent.getDefaultMimeType(".html");
        }

        public long getContentLength() {
            return -1L;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }

    public static interface WebServerContentProvider {
        public WebServerContent getWebServerContent(HTTPRequest var1);
    }
}

