/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.common.Filter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtils {
    private static String COMPONENT_TRANSPARENT_CLIENT_PROPERTY = "nsTransparent";

    private UIUtils() {
    }

    public static Rectangle[] subtract(Rectangle[] rects, Rectangle rect) {
        return UIUtils.subtract(rects, new Rectangle[]{rect});
    }

    public static Rectangle[] subtract(Rectangle[] rects1, Rectangle[] rects2) {
        ArrayList<Rectangle> rectangleList = new ArrayList<Rectangle>(Arrays.asList(rects1));
        ArrayList<Rectangle> newRectangleList = new ArrayList<Rectangle>();
        int i2 = 0;
        while (i2 < rects2.length) {
            Rectangle r2 = rects2[i2];
            for (Rectangle r1 : rectangleList) {
                if (r1.intersects(r2)) {
                    UIUtils.subtract(r1, r2, newRectangleList);
                    continue;
                }
                newRectangleList.add((Rectangle)r1.clone());
            }
            rectangleList.clear();
            if (newRectangleList.isEmpty()) break;
            rectangleList.addAll(newRectangleList);
            newRectangleList.clear();
            ++i2;
        }
        return rectangleList.toArray(new Rectangle[0]);
    }

    private static void subtract(Rectangle r1, Rectangle r2, List<Rectangle> resultList) {
        boolean bottom;
        boolean left = r2.x <= r1.x && r2.x + r2.width > r1.x;
        boolean right = r2.x < r1.x + r1.width && r2.x + r2.width >= r1.x + r1.width;
        boolean top = r2.y <= r1.y && r2.y + r2.height > r1.y;
        boolean bl2 = bottom = r2.y < r1.y + r1.height && r2.y + r2.height >= r1.y + r1.height;
        if (!(left && right && top && bottom)) {
            if (left && right && top) {
                int y2 = r2.y + r2.height;
                int height = r1.y + r1.height - y2;
                resultList.add(new Rectangle(r1.x, y2, r1.width, height));
            } else if (left && right && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
            } else if (top && bottom && left) {
                int x2 = r2.x + r2.width;
                int width = r1.x + r1.width - x2;
                resultList.add(new Rectangle(x2, r1.y, width, r1.height));
            } else if (top && bottom && right) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
            } else if (left && top) {
                int x3 = r2.x + r2.width;
                int y3 = r2.y + r2.height;
                resultList.add(new Rectangle(x3, r1.y, r1.x + r1.width - x3, y3 - r1.y));
                resultList.add(new Rectangle(r1.x, y3, r1.width, r1.y + r1.height - y3));
            } else if (left && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int x4 = r2.x + r2.width;
                resultList.add(new Rectangle(x4, r2.y, r1.x + r1.width - x4, r1.y + r1.height - r2.y));
            } else if (right && top) {
                int y4 = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, y4 - r1.y));
                resultList.add(new Rectangle(r1.x, y4, r1.width, r1.y + r1.height - y4));
            } else if (right && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r1.y + r1.height - r2.y));
            } else if (left && right) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y5 = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y5, r1.width, r1.y + r1.height - y5));
            } else if (top && bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
                int x5 = r2.x + r2.width;
                resultList.add(new Rectangle(x5, r1.y, r1.x + r1.width - x5, r1.height));
            } else if (left) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y6 = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y6, r1.width, r1.y + r1.height - y6));
                int x6 = r2.x + r2.width;
                resultList.add(new Rectangle(x6, r2.y, r1.x + r1.width - x6, r2.height));
            } else if (right) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y7 = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y7, r1.width, r1.y + r1.height - y7));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r2.height));
            } else if (top) {
                resultList.add(new Rectangle(r1.x, r1.y, r2.x - r1.x, r1.height));
                int x7 = r2.x + r2.width;
                resultList.add(new Rectangle(x7, r1.y, r1.x + r1.width - x7, r1.height));
                int y8 = r2.y + r2.height;
                resultList.add(new Rectangle(r2.x, y8, r2.width, r1.y + r1.height - y8));
            } else if (bottom) {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int height = r1.y + r1.height - r2.y;
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, height));
                int x8 = r2.x + r2.width;
                resultList.add(new Rectangle(x8, r2.y, r1.x + r1.width - x8, height));
            } else {
                resultList.add(new Rectangle(r1.x, r1.y, r1.width, r2.y - r1.y));
                int y9 = r2.y + r2.height;
                resultList.add(new Rectangle(r1.x, y9, r1.width, r1.y + r1.height - y9));
                resultList.add(new Rectangle(r1.x, r2.y, r2.x - r1.x, r2.height));
                int x9 = r2.x + r2.width;
                resultList.add(new Rectangle(x9, r2.y, r1.x + r1.width - x9, r2.height));
            }
        }
    }

    public static Rectangle[] getComponentVisibleArea(Component component, Filter<Component> filter) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        int width = component.getWidth();
        int height = component.getHeight();
        if (windowAncestor == null || !component.isShowing() || width <= 0 || height <= 0) {
            return new Rectangle[0];
        }
        Rectangle tempRectangle = new Rectangle(0, 0, width, height);
        Rectangle[] shape = new Rectangle[]{new Rectangle(width, height)};
        if (component instanceof Container) {
            Container container = (Container)component;
            int i2 = container.getComponentCount() - 1;
            while (i2 >= 0) {
                Component c2 = container.getComponent(i2);
                if (c2.isVisible()) {
                    switch (filter.accept(c2)) {
                        case YES: {
                            tempRectangle.setBounds(c2.getX(), c2.getY(), c2.getWidth(), c2.getHeight());
                            shape = UIUtils.subtract(shape, tempRectangle);
                            break;
                        }
                        case TEST_CHILDREN: {
                            if (!(c2 instanceof Container)) break;
                            shape = UIUtils.getChildrenVisibleArea(component, filter, shape, (Container)c2, null);
                        }
                    }
                }
                --i2;
            }
        }
        if (shape.length == 0) {
            return shape;
        }
        Component c3 = component;
        Container parent = c3.getParent();
        while (parent != null && !(parent instanceof Window)) {
            Dimension parentSize = parent.getSize();
            tempRectangle.setBounds(0, 0, parentSize.width, parentSize.height);
            Rectangle parentBounds = SwingUtilities.convertRectangle(parent, tempRectangle, component);
            ArrayList<Rectangle> newRectangleList = new ArrayList<Rectangle>();
            Rectangle[] rectangleArray = shape;
            int n2 = shape.length;
            int n3 = 0;
            while (n3 < n2) {
                Rectangle rectangle = rectangleArray[n3];
                Rectangle r2 = rectangle.intersection(parentBounds);
                if (!r2.isEmpty()) {
                    newRectangleList.add(r2);
                }
                ++n3;
            }
            shape = newRectangleList.toArray(new Rectangle[0]);
            if (parent instanceof JComponent && !((JComponent)parent).isOptimizedDrawingEnabled()) {
                shape = UIUtils.getChildrenVisibleArea(component, filter, shape, parent, c3);
            }
            if (shape.length == 0) {
                return shape;
            }
            c3 = parent;
            parent = c3.getParent();
        }
        return shape;
    }

    public static void setComponentTransparencyHint(Component c2, TransparencyType transparencyType) {
        if (c2 instanceof JComponent) {
            ((JComponent)c2).putClientProperty(COMPONENT_TRANSPARENT_CLIENT_PROPERTY, (Object)transparencyType);
        }
    }

    public static TransparencyType getComponentTransparency(Component c2) {
        if (!(c2 instanceof JComponent) || c2.isOpaque()) {
            return TransparencyType.OPAQUE;
        }
        TransparencyType transparencyType = (TransparencyType)((Object)((JComponent)c2).getClientProperty(COMPONENT_TRANSPARENT_CLIENT_PROPERTY));
        if (transparencyType != null) {
            return transparencyType;
        }
        Container parent = c2.getParent();
        if (parent instanceof JRootPane && ((JRootPane)parent).getGlassPane() == c2) {
            return TransparencyType.TRANSPARENT_WITH_OPAQUE_CHILDREN;
        }
        return TransparencyType.OPAQUE;
    }

    private static Rectangle[] getChildrenVisibleArea(Component component, Filter<Component> filter, Rectangle[] shape, Container parent, Component c2) {
        Component[] children;
        if (parent instanceof JLayeredPane) {
            JLayeredPane layeredPane = (JLayeredPane)parent;
            ArrayList<Component> childList = new ArrayList<Component>(layeredPane.getComponentCount() - 1);
            int layer = c2 == null ? Integer.MIN_VALUE : layeredPane.getLayer(c2);
            int i2 = layeredPane.highestLayer();
            while (i2 >= layer) {
                Component[] components;
                Component[] componentArray = components = layeredPane.getComponentsInLayer(i2);
                int n2 = components.length;
                int n3 = 0;
                while (n3 < n2) {
                    Component child = componentArray[n3];
                    if (child == c2) break;
                    childList.add(child);
                    ++n3;
                }
                --i2;
            }
            children = childList.toArray(new Component[0]);
        } else {
            children = parent.getComponents();
        }
        Rectangle tempRectangle = new Rectangle();
        int i3 = 0;
        while (i3 < children.length) {
            Component child = children[i3];
            if (child == c2) break;
            if (child.isVisible()) {
                Filter.Acceptance accept = filter.accept(child);
                if (accept == Filter.Acceptance.YES) {
                    tempRectangle.setBounds(child.getX(), child.getY(), child.getWidth(), child.getHeight());
                    shape = UIUtils.subtract(shape, SwingUtilities.convertRectangle(parent, tempRectangle, component));
                } else if (accept == Filter.Acceptance.TEST_CHILDREN && child instanceof Container) {
                    shape = UIUtils.getChildrenVisibleArea(component, filter, shape, (Container)child, null);
                }
            }
            ++i3;
        }
        return shape;
    }

    public static Rectangle getBounds(Rectangle[] rectangles) {
        Rectangle bounds = new Rectangle();
        if (rectangles.length > 0) {
            bounds.setBounds(rectangles[0]);
            int i2 = 1;
            while (i2 < rectangles.length) {
                Rectangle.union(bounds, rectangles[i2], bounds);
                ++i2;
            }
        }
        return bounds;
    }

    public static void setPreferredLookAndFeel() {
        try {
            String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(systemLookAndFeelClassName)) {
                UIManager.setLookAndFeel(systemLookAndFeelClassName);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void revalidate(Component c2) {
        if (c2 instanceof JComponent) {
            ((JComponent)c2).revalidate();
        } else {
            c2.invalidate();
            c2.validate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransparencyType {
        OPAQUE,
        TRANSPARENT_WITH_OPAQUE_CHILDREN,
        NOT_VISIBLE;

    }
}

