/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.dj.nativeswing.NSSystemProperty;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObjectRegistry {
    private static Thread cleanUpThread;
    private static Set<ObjectRegistry> registrySet;
    private static int nextThreadNumber;
    private int nextInstanceID = 1;
    private Map<Integer, WeakReference<Object>> instanceIDToObjectReferenceMap = new HashMap<Integer, WeakReference<Object>>();
    private static ObjectRegistry registry;

    static {
        registrySet = new HashSet<ObjectRegistry>();
        registry = new ObjectRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startThread(ObjectRegistry objectRegistry) {
        Set<ObjectRegistry> set = registrySet;
        synchronized (set) {
            registrySet.add(objectRegistry);
            if (cleanUpThread != null) {
                return;
            }
            cleanUpThread = new Thread("Registry cleanup thread-" + nextThreadNumber++){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        ObjectRegistry[] registries;
                        try {
                            1.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Set set = registrySet;
                        synchronized (set) {
                            registries = registrySet.toArray(new ObjectRegistry[0]);
                        }
                        ObjectRegistry[] objectRegistryArray = registries;
                        int n2 = registries.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ObjectRegistry registry;
                            ObjectRegistry objectRegistry = registry = objectRegistryArray[n3];
                            synchronized (objectRegistry) {
                                Integer[] integerArray = registry.instanceIDToObjectReferenceMap.keySet().toArray(new Integer[0]);
                                int n4 = integerArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    Integer instanceID = integerArray[n5];
                                    if (((WeakReference)registry.instanceIDToObjectReferenceMap.get(instanceID)).get() == null) {
                                        registry.instanceIDToObjectReferenceMap.remove(instanceID);
                                    }
                                    ++n5;
                                }
                                if (registry.instanceIDToObjectReferenceMap.isEmpty()) {
                                    Set set2 = registrySet;
                                    synchronized (set2) {
                                        registrySet.remove(registry);
                                    }
                                }
                            }
                            ++n3;
                        }
                        set = registrySet;
                        synchronized (set) {
                            if (registrySet.isEmpty()) {
                                cleanUpThread = null;
                                return;
                            }
                        }
                    }
                }
            };
            boolean isApplet = "applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get());
            cleanUpThread.setDaemon(!isApplet);
            cleanUpThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Object o2) {
        int instanceID;
        boolean isStartingThread = false;
        ObjectRegistry objectRegistry = this;
        synchronized (objectRegistry) {
            do {
                ++this.nextInstanceID;
            } while (this.instanceIDToObjectReferenceMap.containsKey(instanceID));
            if (o2 != null) {
                this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o2));
                isStartingThread = true;
            }
        }
        if (isStartingThread) {
            ObjectRegistry.startThread(this);
        }
        return instanceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o2, int instanceID) {
        ObjectRegistry objectRegistry = this;
        synchronized (objectRegistry) {
            Object o22 = this.get(instanceID);
            if (o22 != null && o22 != o2) {
                throw new IllegalStateException("An object is already registered with the id \"" + instanceID + "\" for object: " + o2);
            }
            this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o2));
        }
        ObjectRegistry.startThread(this);
    }

    public synchronized Object get(int instanceID) {
        WeakReference<Object> weakReference = this.instanceIDToObjectReferenceMap.get(instanceID);
        if (weakReference == null) {
            return null;
        }
        Object o2 = weakReference.get();
        if (o2 == null) {
            this.instanceIDToObjectReferenceMap.remove(instanceID);
        }
        return o2;
    }

    public synchronized void remove(int instanceID) {
        this.instanceIDToObjectReferenceMap.remove(instanceID);
    }

    public synchronized int[] getInstanceIDs() {
        Object[] instanceIDObjects = this.instanceIDToObjectReferenceMap.keySet().toArray();
        int[] instanceIDs = new int[instanceIDObjects.length];
        int i2 = 0;
        while (i2 < instanceIDObjects.length) {
            instanceIDs[i2] = (Integer)instanceIDObjects[i2];
            ++i2;
        }
        return instanceIDs;
    }

    public static ObjectRegistry getInstance() {
        return registry;
    }
}

